#!/usr/bin/perl

=head1 METADATA

<crontab>
    time: 2 0-23/3 * * *
    sharded: 1
    package: scripts-switchman
    <switchman>
        group: scripts-other
    </switchman>
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl: 6h20m
    tag: direct_group_internal_systems
</juggler>

=cut

# $Id$

=head1 DESCRIPTION

Управляет включением и остановкой экспериментов

Возможные параметры:

    --shard-id <shard>
    --e|experiment-id <exp_id>      обрабатывать только указанный эксперимент (можно указывать несколько раз)

=cut


use Direct::Modern;
use my_inc "..";

use Experiments;
use Notification;
use RBAC2::Extended;
use Campaign qw/mass_is_universal_campaign/;

use Settings;
use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';


run() if !caller;



sub run {

    extract_script_params(
        'e|experiment-id=i' => \my @EXP_IDS,
    );

    $log->out('START');

    my $experiments_to_start = Experiments::_query_experiments(PPC(shard => $SHARD), {
            status => 'New',
            date_from__le__dont_quote => 'now()',
            (@EXP_IDS ? ('e.experiment_id' => \@EXP_IDS) : ()),
        });

    $log->out(sprintf 'Found %d experiments to start', scalar @$experiments_to_start);
    for my $experiment (@$experiments_to_start) {
        my $exp_id = $experiment->{experiment_id};
        $log->out("Starting experiment #$exp_id");

        eval {
            Experiments::start_experiment($experiment->{ClientID}, $exp_id);
            1;
        } or $log->out("Failed to start #$exp_id: $@");
    }

    my $experiments_to_stop = Experiments::_query_experiments(PPC(shard => $SHARD), {
            status => 'Started',
            date_to__le__dont_quote => 'now() - interval 1 day',
            (@EXP_IDS ? ('e.experiment_id' => \@EXP_IDS) : ()),
        });

    my $cids = [ map { $_->{primary_cid}, $_->{secondary_cid} } @$experiments_to_stop ];
    my $cid2universal = mass_is_universal_campaign($cids);

    $log->out(sprintf 'Found %d experiments to stop', scalar @$experiments_to_stop);
    for my $experiment (@$experiments_to_stop) {
        my $exp_id = $experiment->{experiment_id};
        $log->out("Finishing experiment #$exp_id");

        Experiments::stop_experiment($experiment->{ClientID}, $exp_id);

        # не отпрвляем письма про универсальные кампании
        if ($cid2universal->{$experiment->{primary_cid}} || $cid2universal->{$experiment->{secondary_cid}}) {
            $log->out("Skip notify. Experiment #$exp_id has universal campaign(s)");
            next;
        };

        notify_client($experiment);
    }

    juggler_ok();

    $log->out('FINISH');
}


sub notify_client {
    my ($experiment) = @_;

    my $vars = { experiment => $experiment };
    state $rbac = RBAC2::Extended->get_singleton(1);
    add_notification($rbac, 'experiment_finished', $vars, {});

    return;
}
