#!/usr/bin/perl

use my_inc "..";



=head1 METADATA

# без заданий потребляет мало памяти, около 250М, но иногда может сожрать 5-6 Гб
<crontab>
    time: */10 * * * *
    <switchman>
        group: scripts-other
        <leases>
            mem: 2500
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl:            33m
    tag: direct_group_internal_systems
</juggler>

<crontab>
    time: */5 * * * *
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>

=cut

=head1 DESCRIPTION

    Делаем возможность группового переноса для супервизоров, тимлидов, супертимлидов:
      - кампаний
      - клиентов
      - агентств
      - менеджеров
    Разрешаем ввод нескольких значений через запятую или отметить галочку "все" (кампании, агентства, клиенты и.т.п. данного менеджера/тимлида).
    По принципу: "Если у заказывающего перенос есть права на объект,
    то он может перенести его кому угодно". Если прав нет, выдаем ошибку типа "Перенос ... невозможен: нет прав".

    Список на перенос ставим в очередь, выполняем от имени супервизора, по результату шлем письмо менеджеру на почту (2 адрес).
    Выполненное действие записываем в логи.

    Все переносы совершаются, включая архивные кампании, остановленные, черновики и.т.п.

    https://jira.yandex-team.ru/browse/DIRECT-8278

    $Id$

=cut

use warnings;
use strict;

use Yandex::DBTools;

use Settings;
use ScriptHelper;

use Campaign;
use Direct::TurboLandings;
use PrimitivesIds;
use Primitives;
use MailService;
use RBAC2::Extended;
use RBACElementary;
use RBACDirect;
use Rbac qw/:const/;
use User;
use BalanceQueue;

use constant SELECT_LIMIT => 500;

#..............................................................................
sub main
{
    $log->out('START');
    my $rbac = RBAC2::Extended->get_singleton(1);

    my $queue_raw = get_all_sql(PPCDICT, "select * from mass_change_owner_queue where status = 'Wait' order by add_time limit ?", SELECT_LIMIT);
    $log->out(sprintf('Got %d tasks from db', scalar @$queue_raw));
    my %queue;

    # группируем по оператору
    for my $task (@$queue_raw) {
        push @{$queue{ $task->{uid} }}, $task
    }

    # выполняем переносы по каждому оператору
    while (my ($uid, $tasks) = each %queue) {

        my %success;
        my %errors;

        for my $task (@$tasks) {
            $log->out({uid => $uid, task => $task});
            $rbac = eval { RBAC2::Extended->get_singleton(1) }
                or $log->die("Error initialising RBAC: $@");

            my $error;
            my ($old_manager, $new_manager) = ($task->{old_owner}, $task->{new_owner});

            if ($task->{object_type} eq 'Cid') {

                my $cid = $task->{object_id};
                eval {
                    die "no rights $old_manager on campaign $cid" unless rbac_is_owner_of_camp($rbac, $old_manager, $cid);
                    $error = rbac_change_manager($rbac, $old_manager, $new_manager, $cid);
                    die "couldn't to change manager for campaign $cid, rbac error: ".( $error == 254 ? "manager set by IDM" : $error)
                        if $error;

                    campaign_manager_changed($rbac, $uid, $cid, $new_manager);
                    Direct::TurboLandings::mass_refresh_metrika_grants_for_all_client_counters(
                        get_clientids(cid => [$cid]), $uid
                    );
                };

            } elsif ($task->{object_type} eq 'Agency') {

                my $agency_uid = $task->{object_id};
                eval {
                    die "no rights $old_manager on agency $agency_uid" unless rbac_is_owner($rbac, $old_manager, $agency_uid);
                    $error = rbac_change_manager_of_agency($rbac, $agency_uid, $old_manager, $new_manager);
                    if ($error) {
                        die "Can't change primary manager for agency $agency_uid".
                            ($error == 1 ? ' - manager set by IDM' : '') ;
                    }

                    my $agency_id = rbac_get_agency_clientid_by_uid( $agency_uid) || die "ClientID for $agency_uid not found";
                    # resend new manager to balance
                    my $agency_uids = Rbac::get_reps(ClientID => $agency_id, role => $ROLE_AGENCY);
                    # ищем в шардах субклиентов агентства все кампании, относящиеся к этому агентству
                    my $cids = get_one_column_sql(PPC(ClientID => rbac_get_subclients_clientids($rbac, $agency_uids)), [
                                                        'SELECT cid FROM campaigns',
                                                        WHERE => {statusEmpty => 'No', AgencyUID => $agency_uids}
                                                      ]);
                    BalanceQueue::add_to_balance_info_queue($uid, cid => $cids, BalanceQueue::PRIORITY_CAMPS_ON_MASS_AGENCY_MANAGER_CHANGED);

                };

            } elsif ($task->{object_type} eq 'Manager') {

                my $manager_uid = $task->{object_id};

                eval {
                    die "no rights $old_manager on manager $manager_uid" unless rbac_is_owner($rbac, $old_manager, $manager_uid);
                    # $old_manager, $new_manager - в данном случае это тимлидеры
                    $error = rbac_move_manager_between_teamleaders($rbac, $manager_uid, $old_manager, $new_manager);
                };

            } else {
                die "not valid object_type: $task->{object_type}";
            }

            my $object = $task->{object_id};
            if ($task->{object_type} ne 'Cid' ) {
                $object = get_login(uid => $task->{object_id});
            }

            my $status;

            if ($@ || $error) {
                push @{ $errors{ $task->{object_type} } }, $object;
                $status = 'Error';
            } else {
                push @{ $success{ $task->{object_type} } }, $object;
                $status = 'Send';
            }

            do_update_table(PPCDICT, 'mass_change_owner_queue', {status => $status, send_time__dont_quote => 'NOW()'}
                                                          , where => {id => $task->{id}}
                                                          ,
                           );

            $log->out({id => $task->{id}, status => $status, error => $error, eval_status => $@});
        }

        # отсылаем письмо с результатами
        my $operator_email = get_manager_email($uid);
        my $mail_vars = {
            fio => get_one_user_field($uid, 'fio')
            , success => \%success
            , errors => \%errors
        };

        send_prepared_mail('mass_change_owner', $operator_email, $Settings::NOTIFICATION_EMAIL_FROM, $mail_vars) if $operator_email;
    }
    juggler_ok();
    $log->out('FINISH');
}

#..............................................................................
main();
