#!/usr/bin/perl


=head1 METADATA

<crontab>
    time: 7 8 * * 1
    <switchman>
        group:  scripts-other
        <leases>
            mem: 180
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl: 8d
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 DESCRIPTION

    Проверка расхождений в метро между геокодером и геобазой
    $Id:$

=cut

=head1 TROUBLESHOOTING

Что делать в случае расхождения

Если не совпадает название - добавить в Metro::format_metro фикс
Если станция не найдена - обновить geobase.pm, запустить mk_regions.pl --files --db и prebuild/get_metro_js.pl

=cut

use warnings;
use strict;
use utf8;
use open ':std' => ':utf8';

use my_inc "..";

use ScriptHelper;

use Settings;
use Metro;
use Yandex::SendMail;
use MailService;

my $DEBUG = 0;
extract_script_params("debug|d" => \$DEBUG);

# region_id, "x,y", название
my @check = (
    [1,   "37.625707,55.749908", 'Москва',],
    [2,   "30.257953,59.971618", 'Санкт-Петербург', ],
    [143, "30.52623,50.447896" , 'Киев', ],
);

my $report_mail = 'direct-maintenance@yandex-team.ru';
$Yandex::SendMail::ENVELOPE_SENDER = $report_mail;

my $email = {to => $report_mail,};
for my $check (@check) {
    my $msg = compare_metro(@$check);
    if ($DEBUG) {
        print $check->[2].": $msg\n";
        next;
    }
    if ($msg) {
        my $subj = 'Расхождение в метро для '.$check->[2];
        $msg .= qq#

Что делать в случае расхождения:

Если не совпадает название - добавить в Metro::format_metro фикс
Если станция не найдена - обновить geobase.pm, запустить mk_regions.pl и prebuild/get_metro_js.pl

#;
        sendmail_with_logging($email, $report_mail, $subj, \$msg, 'text', 'no_logging');
    }
    else {
        sendmail_with_logging($email, $report_mail, $check->[2].": Расхождений в метро не найдено", 
            \"Расхождений в списках станций метро не найдено", 'text', 'no_logging');
    }
}

juggler_ok();
