#!/usr/bin/perl

use my_inc "..";



=head1 METADATA

<crontab>
    time: 19,39,59 * * * *
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl: 1h
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 DESCRIPTION

    вывод разных цифр для мониторинга
    $Id$

=cut

use warnings;
use strict;

use List::Util qw/sum/;

use Yandex::Advmon;
use Yandex::DBTools;
use Yandex::Overshard;

use ScriptHelper 'Yandex::Log' => 'messages';

use Settings;
use Monitor;
use ShardingTools;

# Число баннеров в которых отключены показы на партнерских площадках
my $SQL = '';
my %overshard_opt = ();
for my $proc (map {$_*10} 1..10) {
    my $cl = "c.ContextLimit between ".($proc-9)." and $proc";
    $SQL .= ", sum(c.platform != 'search' and $cl) workcamps_context_limit_$proc\n"
        . ", sum(c.platform != 'search' and c.AgencyUID > 0 and $cl) workcamps_agency_context_limit_$proc\n"
        . ", sum(c.platform != 'search' and c.ManagerUID > 0 and $cl) workcamps_manager_context_limit_$proc\n";
    my $cp = "c.ContextPriceCoef between ".($proc-9)." and $proc";
    $SQL .= ", sum(c.platform != 'search' and $cp) workcamps_contextprice_coef_$proc\n"
        . ", sum(c.platform != 'search' and c.AgencyUID > 0 and $cp) workcamps_agency_contextprice_coef_$proc\n"
        . ", sum(c.platform != 'search' and c.ManagerUID > 0 and $cp) workcamps_manager_contextprice_coef_$proc\n";
    push @{$overshard_opt{sum}}, (
        "workcamps_context_limit_$proc",
        "workcamps_agency_context_limit_$proc",
        "workcamps_manager_context_limit_$proc",
        "workcamps_contextprice_coef_$proc",
        "workcamps_agency_contextprice_coef_$proc",
        "workcamps_manager_contextprice_coef_$proc",
    );
}
push @{$overshard_opt{sum}}, qw/
    workcamps workcamps_agency workcamps_manager
    workcamps_no_context workcamps_no_context_agency
    workcamps_no_context_manager disabled_cnt
    disabled_ips disabled_behavior
/;
my $res =
    overshard_get_one_line(\%overshard_opt,
        PPC(shard => 'all'), "select sum(c.platform = 'search') disabled_cnt 
                                     , count(*) workcamps
                                     , sum(c.AgencyUID > 0) workcamps_agency
                                     , sum(c.ManagerUID > 0) workcamps_manager
                                     , sum(c.platform = 'search') workcamps_no_context
                                     , sum(c.platform = 'search' and c.AgencyUID > 0) workcamps_no_context_agency
                                     , sum(c.platform = 'search' and c.ManagerUID > 0) workcamps_no_context_manager
                                     , sum(IFNULL(c.disabledIps, '')!='') disabled_ips 
                                     , sum(c.statusBehavior!='Yes') disabled_behavior 
                                     $SQL
                                  from campaigns c 
                                  left join campaigns wc on wc.cid = c.wallet_cid
                                 where c.sum - c.sum_spent + IF(c.wallet_cid, wc.sum - wc.sum_spent, 0) > 0.1
                                   and c.statusShow = 'Yes'");
for (qw/disabled_cnt disabled_ips disabled_behavior/) {
    $res->{$_} =  ( $res->{workcamps} ? ($res->{$_} / $res->{workcamps}) : 0 );
}

# новых пользователей за последний час
my $new_users_by_hour = sum @{get_one_column_sql(PPC(shard => 'all'), "
                SELECT count(*) 
                  FROM users
                 WHERE createtime >= unix_timestamp(now() - interval 1 hour)
            ") || [] };

my %advmon_data = (
    'direct' => {
        disabled_yacontext => $res->{disabled_cnt}/100,
        disabled_behavior => $res->{disabled_behavior}/100,
        disabled_ips =>  $res->{disabled_ips}/100,
        new_users_by_hour => $new_users_by_hour,
    },
);

monitor_values({
    "direct.turned_off"  => sprintf("%.2f", $res->{disabled_cnt}),
    "direct.iplimit"     => sprintf("%.2f", $res->{disabled_ips}),
    "direct.behavioroff" => sprintf("%.4f", $res->{disabled_behavior}),

    %advmon_data,
});

my $to_save = {map {($_ => { value => $res->{$_} })} grep {/
        ^(
            disabled_behavior
            | disabled_ips
            | workcamps(_no_context)?(_agency|_manager)?
            | workcamps.*_(context_limit|contextprice_coef)_\d+
        )$/x} keys %$res};

$to_save->{disabled_behavior}->{desc} = "процент кампаний с отключенным поведенческим таргетингом";
$to_save->{disabled_ips}->{desc} = "процент кампаний с фильтрацией по ip";
$to_save->{workcamps}->{desc} = "количество работающих кампаний";
$to_save->{workcamps_no_context}->{desc} = "работающих кампаний с отключенными показами в сети";
$to_save->{workcamps_no_context_agency}->{desc} = "работающих агентских кампаний с отключенными показами в сети";
$to_save->{workcamps_no_context_manager}->{desc} = "кампаний, обслуживаемых менеджером, с отключенными показами в сети";
$to_save->{workcamps_agency}->{desc} = "работающих агентских кампаний";
$to_save->{workcamps_manager}->{desc} = "работающих кампаний, обслуживаемых менеджером";
    
for my $key (grep {/^workcamps/} keys %$to_save){
    my ($proc) = $key =~ /_(\d+)$/;
    next unless $proc;
    my $camp_type = $key =~ /_manager_/ ? "обслуживаемых менеджером  " : $key =~ /_agency_/ ? "агентских " : "";
    my $restriction = $key =~ /_contextprice_coef_/ ? "цены" : $key =~ /_context_limit_/ ? "расхода" : "Ошибка!";

    $to_save->{$key}->{desc} = 
    "работающих ${camp_type}кампаний с ограничением $restriction в РСЯ на $proc%";
}

Monitor::save_values($to_save);

juggler_ok();
