#!/usr/bin/perl

use my_inc "..";



=head1 METADATA

<crontab>
    time: 30 18-23 * * *
    <switchman>
        group: scripts-other
        <leases>
            mem: 260
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    ttl: 2d4h
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 DESCRIPTION

    Считает и пишет в таблицы monitor_values_.* разные значения
    Значения -- разные, но которые хочется считать примерно раз в день

    пытаться запускать скрипт надо несколько раз в день на случай непредвиденных сбоев

    $Id$

=head1 RUNNING

    LOG_TEE=1 ./protected/ppcMonitorDaily.pl
    LOG_TEE=1 ./protected/ppcMonitorDaily.pl --only-sub multicurrency_values

=cut

use warnings;
use strict;

use List::MoreUtils qw/none/;

use Yandex::TimeCommon;
use Yandex::HashUtils;
use Yandex::Advmon;

use Settings;
use ScriptHelper 'Yandex::Log' => 'messages';

use Direct::Monitor::Daily;
use Monitor;
use Property;

$log->out("start, configuration: $Settings::CONFIGURATION");

my @only_subs;
extract_script_params(
    'only-sub=s@' => \@only_subs,
);

my ($now, $laststart_prop);
if (@only_subs) {
    $log->out("Running only subs: " . join(', ', @only_subs));
} else {
    $now = unix2mysql(ts_round(time, "day")); 
    $laststart_prop = new Property('MONITOR_DAILY_LASTSTART'); 
    my $laststart = $laststart_prop->get() || '';
    if ($laststart eq $now ) {
        $log->out("nothing to do for today...");
        juggler_ok(description => 'already worked today');
        exit;
    }
}

my %all_ret;
my $failed = 0;
for my $sub (@Direct::Monitor::Base::SUBS) {
    if (@only_subs) {
        next if none {$sub->{name} && $sub->{name} eq $_} @only_subs;
    }
    $log->out("start $sub->{name}");
    eval {
        my $ret = $sub->{code}->();
        Monitor::save_values($ret);
        hash_merge \%all_ret, {map {$_ => ref $ret->{$_} ? $ret->{$_}->{value} : $ret->{$_}} keys %$ret};
        $log->out($ret);
    };
    if ($@) {
        $log->out("failed $sub->{name}: $@");
        $failed++;
    } else {
        $log->out("end $sub->{name}");
    }
}

monitor_values({
    "direct.yacategories" => sprintf("%.2f", 100 * $all_ret{"yacontext.binded_contexts_num"} / ($all_ret{"yacontext.contexts_num"} || 1)),
    (map {("direct.unfamily.$_" => $all_ret{"unfamily.$_"})} qw/antispam_no_moderation_yes antispam_yes_moderation_no/),

    direct => \%all_ret,
});

if (!$failed && !@only_subs) {
    $laststart_prop->set($now);
    juggler_ok();
    $log->out("finish");
}
exit $failed;
