#!/usr/bin/perl

use my_inc "..";


=head1 METADATA

<crontab>
    time: */10 * * * *
    sharded: 1
    <switchman>
        group: scripts-other
        <leases>
            mem: 50
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    time: */10 * * * *
    sharded: 1
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl: 3h
    tag: direct_group_api
</juggler>

<monrun>
    juggler_host:   checks_auto.direct.yandex.ru
    name: StoreContent.outdated_content_cnt
    crit: 1
    expression: 'keepLastValue(direct_one_min.db_configurations.production.flow.StoreContent.outdated_content_cnt.shard_$shard)'
    sharded: 1
    tag: direct_group_api
</monrun>
<monrun>
    juggler_host:   checks_auto.direct.yandex.ru
    name: StoreContent.oldest_content_refresh_time
    warn: 90000
    span: 36h
    expression: 'diffSeriesTime(keepLastValue(direct_one_min.db_configurations.production.flow.StoreContent.oldest_content_refresh_time.shard_$shard))'
    sharded: 1
    tag: direct_group_api
</monrun>


=cut

=head1 NAME

ppcMonitorUpdateStoreContent.pl

=head1 DESCRIPTION

    Скрипт предназначен для мониторинга обновления данных по мобильному контенту в таблице ppc.mobile_content
    Обновление данных производится скриптом ppcUpdateStoreContent.pl

=cut


use Direct::Modern;

use Yandex::Advmon;
use Yandex::DBTools;

use ScriptHelper 'Yandex::Log' => 'messages', sharded => 1;
use Settings;

use Yandex::TimeCommon qw/unix2human/;

extract_script_params();

# Считаем мобильный контент устаревшим,
# если он не обновлялся дольше заданного количества часов
my $outdated_timeout = 48;

$log->out('START');

# Количество записей, которые не обновлялись дольше заданного таймаута
my $outdated_cnt = get_one_field_sql(PPC(shard => $SHARD), "SELECT COUNT(*)
                                                            FROM mobile_content
                                                            WHERE GREATEST(modify_time, create_time, store_refresh_time) < DATE_SUB(NOW(), INTERVAL $outdated_timeout HOUR)
                                                            AND tries_count < $Settings::MOBILE_APPLICATION_TRIES_LIMIT");
$log->out("Outdated content count: $outdated_cnt");
# Время последнего успешного обновления и время самой старой попытки обновления
my ($last_success, $oldest_refresh) = get_one_line_array_sql(PPC(shard => $SHARD),
                                                         "SELECT UNIX_TIMESTAMP(IFNULL(MAX(modify_time), NOW())),
                                                                 UNIX_TIMESTAMP(IFNULL(MIN(GREATEST(modify_time, create_time, store_refresh_time)), NOW()))
                                                         FROM mobile_content
                                                         WHERE tries_count < $Settings::MOBILE_APPLICATION_TRIES_LIMIT");
$log->out("Last success update: ".unix2human($last_success));
$log->out("Oldest content refresh time: ".unix2human($oldest_refresh));
# пишем данные для мониторинга
local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $Settings::CONFIGURATION]};
monitor_values({
    "flow.StoreContent.outdated_content_cnt.shard_$SHARD" => $outdated_cnt,
    "flow.StoreContent.last_success_update.shard_$SHARD" => $last_success,
    "flow.StoreContent.oldest_content_refresh_time.shard_$SHARD" => $oldest_refresh,
});

$log->out('Sending OK to juggler');
juggler_ok();

$log->out('FINISH');
