#!/usr/bin/perl

use my_inc "..";


=head1 METADATA

<crontab>
    time: */5 * * * *
    sharded: 1
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded:    1
    ttl:        20m
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 DESCRIPTION

 Подписываем всех новые логины в паспорте на директовский sid,
 выбираем последовательно новые логины из users отсортированные по createtime пачками по 10000
 и подписываем их в паспорте, если еще не подписаны

 запускаем раз в 5 минут (как в директе будет создаваться более 10000 логинов за 5 минут, константу нужно будет увеличить)

 https://jira.yandex-team.ru/browse/DIRECT-12129

 $Id$

=cut

use warnings;
use strict;

use Settings;
use Yandex::DBTools;
use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';
use Property;
use Primitives;
use Yandex::Passport;
use Yandex::TVM2;

use utf8;
use open ':std' => ':utf8';
binmode STDERR, 'utf8';

our $MAX_NEW_LOGINS = 10_000; # кол-во новых логинов для подписи

#-----------------------------------------------------------
sub main
{
    extract_script_params();
    my $last_users_prop = new Property($ScriptHelper::script_name);

    my $val = $last_users_prop->get();
    my ($last_createtime, $last_login) = split /;/, $val || '0;';
    $last_login = '' unless $last_login;
    $log->out("start: $last_createtime, $last_login");

    my $new_users = get_all_sql(PPC(shard => $SHARD), "select login, createtime, uid, description
                                      from users
                                      where createtime >= ?
                                        and (createtime > ? or login > ?)
                                        and createtime < unix_timestamp(now()) - 60
                                        and login != ''
                                      order by createtime, login
                                      limit $MAX_NEW_LOGINS
                                     ", $last_createtime, $last_createtime, $last_login
                                     );

    if (@$new_users) {
        for my $row (@$new_users) {
            # TEMPORARY - эти логины - lite-account (социальная авторизация) и стопорят всю очередь
            if ($row->{login} =~ /\@/) {
                $log->warn("Skipped lite-account: uid $row->{uid}, login $row->{login}");
                next;
            }

            $last_login = $row->{login};
            $last_createtime = $row->{createtime};

            eval {
                my $last_uid = get_uid_by_login($last_login);
                if ($last_uid) {
                    if (! check_direct_sid($last_login)) {
                        # если логин существует и еще не подписан
                        my $ticket = eval { Yandex::TVM2::get_ticket($Settings::PASSPORT_TVM2_ID) } or die "Cannot get ticket for $Settings::PASSPORT_TVM2_ID: $@";
                        my $result = Yandex::Passport::subscribe_service($last_uid, undef, undef, undef, tvm_ticket => $ticket);
                        my $result_str = $result ? 'Failed' : 'Ok';
                        $log->out("subscribe: $last_login - $result_str / $result");
                        die "$last_login subscribe failed\n" if $result;
                    } else {
                        $log->out("already subscribed: $last_login");
                    }
                } else {
                    # логин удален, помечаем
                    do_update_table(PPC(shard => $SHARD), 'users'
                                    , {description => 'deleted_in_passport' . ($row->{description} || '')}
                                    , where => {uid => $row->{uid}});
                    $log->out("login deleted: $last_login ($row->{uid})");
                }
            };
            $log->die("subscribe error on $last_login ($row->{uid}): $@") if $@;
        }

        $log->out("finish: $last_createtime, $last_login");
        $last_users_prop->set("$last_createtime;$last_login");
    } else {
        $log->out("no new users, finish");
    }

    juggler_ok();
}

#-----------------------------------------------------------
main();
