#!/usr/bin/perl

=head1 METADATA

<crontab>
    time: */2 * * * *
    sharded: 1
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    name:           scripts.ppcPdfReports.monitoring
    raw_events:     scripts.ppcPdfReports.monitoring.shard_$shard
    sharded:        1
    ttl:            40m
    tag: direct_group_internal_systems
</juggler>

=cut

# $Id$

=head1 NAME

    ppcPdfReportsMonitoring.pl - Скрипт мониторинга очереди PDF отчётов.

=cut

=head1 DESCRIPTION

    Скрипт собирает статистику по очереди PDF-отчетов и пишет ее в графит.

=cut

use Direct::Modern;

use Yandex::Advmon;
use Yandex::DBTools;

use my_inc "..";

use PdfReport::Queue;
use ScriptHelper 'Yandex::Log' => 'messages', sharded => 1;
use Settings;

local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $Settings::CONFIGURATION]};

=head1 SUBROUTINES/METHODS/VARIABLES

=head2 $MIN_ITERATION_DURATION

    минимальное время итерации
    если итерация закончилась быстрее - делаем sleep

=cut

my $MIN_ITERATION_DURATION = 2 * 60;

=head2 @stat_types

    какую статистику считаем и каким sql-условием

=cut

my @stat_types = (
    { name => 'reports_pending',    cond => "NOT(status = 'processing' AND rank > $PdfReport::Queue::ATTEMPTS)" },
    { name => 'reports_failed',     cond => "status = 'processing' AND rank > $PdfReport::Queue::ATTEMPTS" },
);

my $ONCE;
extract_script_params(
    'once' => \$ONCE,
);

$log->out('START');
my @stat_conditions;

for my $stat_type (@stat_types) {
    for my $queue_name (keys %PdfReport::Queue::QUEUES) {
        push @stat_conditions, join (' ',
            "SUM(IF(", $stat_type->{cond}, "AND", sql_condition($PdfReport::Queue::QUEUES{$queue_name}), ",1,0))",
            "AS `$stat_type->{name}.$queue_name`"
        );
    }
    # подстраховка от того, что просыпали часть отчетов мимо условий из %PdfReport::Queue::QUEUES
    push @stat_conditions, "SUM(IF($stat_type->{cond},1,0)) AS `$stat_type->{name}.all_queues`";
}

while (1) {
    my $iter_start_time = time();
    if (my $reason = smart_check_stop_file()) {
        $log->out("$reason! Exiting.");
        exit 0;
    } else {
        restart_tracing();
    }

    $log->out("Fetching stats from shard $SHARD");
    my $shard_stats = get_one_line_sql(PPC(shard => $SHARD), 'SELECT ' . join(', ', @stat_conditions) . ' FROM pdf_reports WHERE status != "ready"');
    $log->out($shard_stats);
    monitor_values({
        flow => { PdfReports => { map { ("$_.shard_$SHARD" => ($shard_stats->{$_}//0)) } keys %$shard_stats } },
    });

    last if $ONCE;
    juggler_ok(service => "scripts.ppcPdfReports.monitoring.shard_$SHARD");

    my $sleep_time = $MIN_ITERATION_DURATION + $iter_start_time - time();
    if ($sleep_time > 0) {
        $log->out("sleep for $sleep_time seconds");
        sleep($sleep_time);
    }
}

$log->out('FINISH');
