#!/usr/bin/perl

=head1 METADATA

<crontab>
    time: */2 * * * *
    sharded: 1
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    name:           scripts.ppcPdfReports.recycling
    raw_events:     scripts.ppcPdfReports.recycling.shard_$shard
    sharded:        1
    ttl:            7m
    tag: direct_group_internal_systems
</juggler>

=cut

# $Id$

=head1 NAME

    ppcPdfReportsRecycling.pl - Скрипт для отслеживания "зависших" PDF отчетов в очереди

=cut

=head1 DESCRIPTION

    Скрипт обрабатывает "зависшие" PDF-отчеты:
        это отчеты в статусе processing с несуществующим connection_id (то есть скрипт генерации "отвалился")
        такие отчеты заново помечаются как "новые" (с сохранением количества попыток генерации)

=cut

use Direct::Modern;

use my_inc "..";

use PdfReport::Queue;
use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';
use Settings;

extract_script_params();

$log->out('START');

PdfReport::Queue::recycleGarbageReports( shard => $SHARD, log => $log ) or $log->die("Failed to recycle some bad PDF reports");

juggler_ok(service => "scripts.ppcPdfReports.recycling.shard_$SHARD");

$log->out('FINISH');
