#!/usr/bin/perl

use my_inc "..";

#
#   Process redirect check queue 
#   
#  $Id$ 
#
####################################################################



=head1 METADATA

<crontab>
    time: * * * * *
    sharded: 1
    <switchman>
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded:    1
    ttl:        30m
    tag: direct_group_internal_systems
</juggler>
<monrun>
    juggler_host: checks_auto.direct.yandex.ru
    name: direct.redirect.max_age
    crit: 172800
    sharded: 1
    expression: 'movingAverage(one_min.direct.production.direct.redirect.shard_$shard.max_age, "10min")'
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>
<monrun>
    juggler_host: checks_auto.direct.yandex.ru
    name: direct.redirect.queue_size
    crit: 300000
    sharded: 1
    expression: 'movingAverage(one_min.direct.production.direct.redirect.shard_$shard.queue_size, "10min")'
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>
<monrun>
    juggler_host: checks_auto.direct.yandex.ru
    name: direct.redirect.queue_cnt_domains
    crit: 600
    sharded: 1
    expression: 'movingAverage(one_min.direct.production.direct.redirect.shard_$shard.queue_cnt_domains, "10min")'
    tag: direct_group_internal_systems
    tag: direct_queues
</monrun>

=head1 DESCRIPTION

    Редиректы давно уже обрабатывает https://a.yandex-team.ru/arc_vcs/direct/jobs/src/main/java/ru/yandex/direct/jobs/redirects/RedirectCheckJob.java
    Здесь остался только подсчет статистики и отправка в графит

    Опции командной строки:
    --help - вывести справку
    --shard-id - ID шарда

=cut

use warnings;
use strict;
use utf8;

use Yandex::Advmon;

use ScriptHelper 'get_file_lock' => ['dont die'], sharded => 1, 'Yandex::Log' => 'messages';
use RedirectCheckQueue;

extract_script_params();

$log->out("START");

monitor_values(RedirectCheckQueue::calc_monitor_values($SHARD));

juggler_ok();
$log->out("FINISH");

exit 0;
