#!/usr/bin/perl

=head1 METADATA

<crontab>
    time: */10 * * * *
    sharded: 1
    package: scripts-switchman
    <switchman>
        group: scripts-other
    </switchman>
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl: 1h
    tag: direct_group_internal_systems
</juggler>

=cut

# $Id$

=head1 NAME

    ppcSendPausedByDayBudgetMails.pl

=head1 DESCRIPTION

    Рассылает уведомления об остановке кампаний/общих счетов по дневному бюджету.
    Для отправки письма по каманиями у нас должна быть дата приостановки и по статистике должна быть истрачена сумма,
    превышающая дневной бюджет.
    Уведомления для остановленных по временному таргетингу кампаний не отправляются.

    Для общих счетов сегодняшние открутки не высчитываются, т.к., в отличие от просто кампаний, статус приостановки в интерфейсе
    выставляется не на основе сегодняшних откруток, а на основе поля co.day_budget_stop_time.
    Для отправки письма по общему счету нужно, чтобы под ним была хотя бы одна камания, по которой имеет смысл такое уведомление отправлять
    (см @DayBudgetAlerts::SQL_WHERE_CAMP_MAKES_SENSE_TO_SEND_NOTIFICATION)

    Возможные параметры:

        --cid <cid>
            обрабатывать только указанную кампанию. Можно указывать несколько раз: ppcSendPausedByDayBudgetMails.pl --cid 111 --cid 222 --cid 333

        --shard-id <shard>

=cut

use Direct::Modern;
use open ':std' => ':utf8';

use my_inc "..";

use ScriptHelper 'Yandex::Log' => 'messages', sharded => 1;

use DayBudgetAlerts;

my @PARAM_CIDS;
extract_script_params(
    'cid=i' => \@PARAM_CIDS,
);

$log->out('START');

$DayBudgetAlerts::LOG = $log;

send_campaigns_paused_by_day_budget_alerts($SHARD, \@PARAM_CIDS);
send_wallets_paused_by_day_budget_alerts($SHARD, \@PARAM_CIDS);

juggler_ok();

$log->out('FINISH');
