#!/usr/bin/perl

# $Id$

=hea1 NAME

    ppcSendSMS.pl - отправляет смс-сообщения из очереди

=head1 DESCRIPTION

    Параметры запуска:
    --shard-id  - номер шарда в котором требуется обработать очередь.

    Сообщения не отправляются, если на них наложено ограничение по времени отправки
        (текущее время вне диапазона заданного на кампании/пользователе)
    Ожидающие в очереди сообщения через определенное время "протухают"
        и помечаются как "просроченные" - попыток их отправить более не будет

=cut

=head1 METADATA

<crontab>
    time: */2 * * * *
    sharded: 1
    <switchman>
        group: scripts-other
        <leases>
            mem: 180
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl: 15m
    tag: direct_group_internal_systems
    <notification>
        template: on_status_change
        status: OK
        status: CRIT
        method: telegram
        login: DISMonitoring
    </notification>
</juggler>

<crontab>
    time: */10 * * * *
    sharded: 1
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>

=cut

use Direct::Modern;

use Yandex::Advmon;

use my_inc "..";

use MailService;
use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';
use Settings;


my @ONLY_CIDS;

extract_script_params(
    'cid=i@' => \@ONLY_CIDS
);


$log->out('START');

# отправляем все что у нас есть
my $sms_count = process_sms_queue(shard => $SHARD, cid => \@ONLY_CIDS, log => $log);

# помечаем старые сообщения как "просроченные"
expire_old_sms_in_queue(shard => $SHARD);

local $Yandex::Advmon::GRAPHITE_PREFIX = sub {[qw/direct_one_min db_configurations/, $Settings::CONFIGURATION]};
monitor_values({
    flow              => { SendSMS => {
                                        processed_count => { "shard_$SHARD" => $sms_count }
                                        # TODO - expried count
                                      },
                         },
});

juggler_ok();

$log->out('FINISH');
