#!/usr/bin/perl

=head1 METADATA
<crontab>
    time: */5 * * * *
    sharded: 1
    <switchman>
        group: scripts-other
        <leases>
            mem: 245
        </leases>
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    sharded: 1
    ttl:            20m
    tag: direct_group_internal_systems
</juggler>
#TODO: monrun проверка на количество ошибочных отправок
<crontab>
    time: */10 * * * *
    sharded: 1
    <switchman>
        group: scripts-test
    </switchman>
    package: conf-test-scripts
</crontab>
=cut

######################################################################
#
#  Direct.Yandex.ru
#
#  ppcServicingCampEvents.pl (old: send_events.pl)
#  send all notifications for servicing campaigns
#
#  $Id$
#  (c) 2004, 2009 Yandex
#
######################################################################

=head1 DESCRIPTION
  Посылаем изменения по сервисируемым кампаниям, клиентам - все что менял менеджер,
  менеджерам - только событие остановки кампании.
  Если изменения делал не менеджер (саппорт, тимлидер), то посылаем копию и клиенту и менеджеру.
  Группируем все события по одной кампании в одно письмо, кроме оплаты - оплата отдельным письмом (и только клиенту).
  Выбираем только кампании директа (по Баяну уведомления не посылаем)
  шаблоны:
    campaign_stop_to_manager - менеджерам
    campaign_servicing_camp_events - клиентам
  https://jira.yandex-team.ru/browse/DIRECT-4763
=head1 RUNNING
    Опции командной строки:
        --cid cid1 --cid cid2 ,...
            работать только с событиями по указанным кампаниями
=cut

use warnings;
use strict;

use my_inc "..";


use Yandex::DBTools;
use Yandex::ScalarUtils;

use ScriptHelper sharded => 1, 'Yandex::Log' => 'messages';

use Settings;


my $MEDIAPLAN_INTERVAL = '30 minute';


#---------------------------------------------------------------------
sub main
{
    $log->out("START");

    my (@cids);
    extract_script_params(
        'cid=s@' => \@cids,
    );

    # send events ....................................................
    # выбираем события по директовским кампаниям
    my $events_chunk = get_all_sql(PPC(shard =>$SHARD), ["select eid from events",
                                            (@cids ? (where => {cid => \@cids}) : ()),
                                            "order by eid
                                             limit 1000000 "]);
    $log->out("fetched " . scalar(@$events_chunk) . " events");

    if (@$events_chunk) {
        my %events_to_set_sent;
        for my $row (@$events_chunk) {
            $events_to_set_sent{ $row->{eid} } = undef;
        }

        # update statusSent on events
        do_delete_from_table(PPC(shard => $SHARD), 'events', where => {eid => [keys %events_to_set_sent]});

        $log->out("events processed");
    }

    $log->out("FINISH");
}

#---------------------------------------------------------------------
main();
