#!/usr/bin/perl

use my_inc "..";



=head1 METADATA

<crontab>
    params: --uniq 1
    time: */2 * * * *
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    params: --uniq 2
    time: */2 * * * *
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    params: --uniq 3
    time: */2 * * * *
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    params: --uniq 4
    time: */2 * * * *
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    params: --uniq 5
    time: */2 * * * *
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    params: --uniq 6
    time: */2 * * * *
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    params: --uniq 7
    time: */2 * * * *
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<crontab>
    params: --uniq 8
    time: */2 * * * *
    package: scripts-switchman
    <switchman>
        group: scripts-other
        <leases>
            mem: 1024
        </leases>
    </switchman>
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    raw_events:     scripts.ppcXLSReports.working.uniq_$uniq
    vars:           uniq=1,2,3,4,5,6,7,8
    ttl:            30m
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 NAME

    ppcXLSReports.pl - демон обработки очереди запросов на формирование
                       отчетов по статистике кампании

=head1 DESCRIPTION

    Опции командной строки:
    --uniq - обязательный параметр, цифра, позволяющая развести несколько
             скриптов на одной машине
    --help - вывести справку
    --once - отработать одну итерацию и выйти
    --cid  - работать только с указанной кампанией (можно указать несколько раз)

=head2 EXAMPLE

    LOG_TEE=1 ./protected/ppcXLSReports.pl --uniq 1 --once --cid 123

=cut

use strict;
use warnings;

use JSON;
use List::MoreUtils qw/any/;
use List::Util qw/min/;
use Time::HiRes;

use Settings;
use ScriptHelper get_file_lock => undef, 'Yandex::Log' => 'messages';
use Yandex::DBTools;
use LockTools;
use Yandex::HashUtils;
use Yandex::ProcInfo;

use CampStat;
use Campaign::Types;
use Stat::Fields;
use StatXLS;
use RBAC2::Extended;
use PrimitivesIds;
use Notification;
use Yandex::I18n;
use User;

use utf8;

# Пауза после пустой итерации
my $EMPTY_LOOP_SLEEP = 10;
# максимальный размер памяти, отведенный под процесс
my $MAX_PROC_SIZE = 1_000_000_000;

my $SCRIPT = get_script_name();

my ($ONCE, $UNIQ, @cids);
extract_script_params(
    "once"   => \$ONCE,
    "uniq=i" => \$UNIQ,
    'cid=s'  => \@cids,
);
if (($UNIQ || q{}) !~ /^\d+$/) {
    usage();
}

$log->msg_prefix("[uniq_$UNIQ]");

# имя SQL лока
my $SQL_LOCK_NAME = $SCRIPT."_LOCK_".$UNIQ;

if (!get_file_lock('dont die', "$SCRIPT.$UNIQ")) {
    exit 0;
}

if (!get_lock_sql(PPCDICT, $SQL_LOCK_NAME, 1)) {
    die "Can't get mysql lock";
}

$log->out('Start');

my $json = JSON->new;

my $sleep_time = 0;
while (1) {
    # Внутри цикла делаются next, поэтому спать в конце итерации -- ненадежно
    # В конце итерации только запоминаем, сколько поспать, а спим в самом начале
    # альтернативный вариант -- "фреймворк" бесконечных циклов с семантикой "повторять функцию вечно, но не чаще, чем порог и не дольше другого порога"

    if( $sleep_time > 0.001 ){
        $log->out(sprintf "Sleep %.3f seconds before next task", $sleep_time);
        Time::HiRes::sleep($sleep_time);
    }
    $sleep_time = $EMPTY_LOOP_SLEEP;

    restart_tracing();

    if (my $reason = smart_check_stop_file()) {
        $log->out("$reason! Let's finish.");
        last;
    }

    my $t1 = Time::HiRes::time();

    my $juggler_descr = 'OK';

    CampStat::release_abandoned_orders();

    my $vars;
    my $order = CampStat::get_order((@cids) ? (cids => \@cids) : ());
    if ($order) {
        $log->out("get order $order->{id} cid: $order->{cid}");
        $juggler_descr = "cid $order->{cid}, created $order->{create_time}. ";

        $vars = eval { $json->decode($order->{vars}) };
        if ($@) {

            if ($ONCE) {
                $log->die("JSON: $@");
            }
            else {
                $log->out("JSON: $@");
                juggler_crit(service_suffix => "uniq_$UNIQ", description => "$juggler_descr $@");

                next;
            }
        }

    } else {
        $log->out( $juggler_descr = 'no reports' );
        juggler_ok(service_suffix => "uniq_$UNIQ", description => $juggler_descr);
        last if $ONCE;
        next;
    }
    
    if ($order && ref $vars eq 'HASH') {
        my $dbstat;
        if ($vars->{OrderID} && !($vars->{stat_type} 
            && $vars->{stat_type} =~ /^(?:campdate|by_clients|by_managers|by_agency_clients|by_agencies)$/)) {

            $dbstat = Stat::CustomizedArray->new(OrderID =>  $$vars{OrderID});

            if ($vars->{stat_type} && $vars->{stat_type} eq 'geo') {
                $dbstat->set_report_parameters(
                    translocal_params => { ClientID => get_clientid(uid => get_uids(OrderID => $vars->{OrderID})->[0]) }
                );
            } else {
                # при построении любого отчета - создается "транслокальное" геодерево,
                # однако используется оно только при группировке по гео.
                # передаем параметры по умолчанию, чтобы исключить выдачу предупреждения "translocal options not found"
                $dbstat->set_report_parameters(translocal_params => { tree => 'api' });
            }
        }

        my $rbac = eval { RBAC2::Extended->get_singleton( $vars->{UID} ) };
        unless ($rbac) {
            my $msg = "Failed to get RBAC handler for $vars->{UID}: $@";

            if ($ONCE) {
                $log->die($msg);
            }
            else {
                $log->out($msg);
                juggler_crit(service_suffix => "uniq_$UNIQ", description => "$juggler_descr $msg");
                next;
            }
        }

        $log->out("generate statistic");
        hash_merge $vars, CampStat::get_camp_stat($rbac, $vars, $dbstat);
        $log->out("finish generate statistic");

        my $skip_column = { map {$_ => 1} qw/aprgoodmultigoal uniq_viewers avg_view_freq avg_cpm aprgoodmultigoal_cpa aprgoodmultigoal_conv_rate
            auction_hits auction_wins auction_win_rate imp_to_win_rate imp_reach_rate served_impressions/,
            Stat::Fields::get_countable_to_skip_in_camp_stat_xls(),
        };

        my $is_bayan = (($vars->{stat_type}||'') =~ m/^(?:geo|pages)$/ || $vars->{detail} || $vars->{phrasedate} and is_media_camp(OrderID => $vars->{OrderID}) or !$vars->{is_direct} and ($vars->{stat_type}||'') =~ m/campdate/) ? 1 : 0; 

        if ($vars->{directya} or $is_bayan) {
            hash_merge $skip_column, {
                adepth    => 1,
                aconv     => 1,
                agoalcost => 1,
                agoalroi  => 1,
                agoalincome => 1,
            };
        }
        if ($is_bayan) {
            hash_merge $skip_column, {
                sum         => 1,
                av_sum      => 1,
                agoalcost   => 1,
            };
        }

        # Post View поля показываем только в МОК
        hash_merge $skip_column, Stat::Fields::get_post_view_fields_to_skip_in_camp_stat_xls();

        my $lang = eval { get_user_data($vars->{uid}, ["lang"])->{lang} } || 'ru';
        my $lang_guard = Yandex::I18n::init_i18n_guard($lang, check_file => 1);

        $log->out("xls report generate ($lang), type: ",
                $vars->{stat_type}  ? "stat_type: $vars->{stat_type}"
            :   $vars->{detail}     ? "detail: $vars->{detail}"
            :   $vars->{phrasedate} ? "phrasedate: $vars->{phrasedate}"
            :   ' common'
        );

        my $report_name;
        if (defined $vars->{stat_type} && $vars->{stat_type} eq 'campdate') {
            $report_name = 'campaigns';
        } elsif (defined $vars->{detail}) {
            $report_name = 'date';
        } elsif (defined $vars->{phrasedate}) {
            $report_name = 'phrase_date';
        } else {
            $report_name = (defined $vars->{stat_type} && any{$_ eq $vars->{stat_type}} @StatXLS::ALLOWED_TYPES)
                            ? $vars->{stat_type}
                            : 'common';
        }
        ($order->{file_type}, $order->{xls_data}) = StatXLS::stat_excel("statxls_$report_name" => $vars, $skip_column);

        $log->out('xls report generated');

        # hack: уникализируем имя файла для хранилища
        my $mail_report_name = $order->{report_name};
        $order->{report_name} =~ s/(?=\.xls)/-$order->{id}/xms;

        CampStat::finish_order($order, uid => $vars->{uid});

        my $camp = get_one_line_sql(
            PPC(cid => $vars->{cid}),
            "select c.cid, c.uid, c.ClientID, c.name as camp_name, co.fio, co.email, co.offlineStatNotice = 'Yes' as offlineStatNotice
            from campaigns c left join camp_options co on (c.cid = co.cid)    
            where c.uid=? and c.cid=?",
            $vars->{uid}, $vars->{cid}
        );
        if ( $camp->{'offlineStatNotice'} ) {
            my $mail_vars = {
                cid         => $camp->{cid},
                fio         => $camp->{fio},
                report_name => $mail_report_name,
                uid         => $camp->{uid},
                camp_name   => $camp->{camp_name}
            };
            $log->out('send notification: ' 
                . join ', ', map {+"$_: " . ($camp->{$_} || $order->{$_})} keys %$mail_vars
            );
            add_notification($rbac, 'offline_stat_ready', $mail_vars);
        }
    }

    $log->out("Finish get statistic for $vars->{OrderID}");

    juggler_ok(service_suffix => "uniq_$UNIQ", description => $juggler_descr);

    if ($ONCE) {
        last;
    }
    disconnect_all();

    # проверяем, не сильно ли мы разбухли
    my $size = Yandex::ProcInfo::proc_memory();
    if ($size > $MAX_PROC_SIZE) {
        my $msize = int($size / 1024 / 1024);
        $log->out("Process [$$] too big: rss=${msize}Mb, exit\n");
        exit 0;
    }

    # делаем паузу, чтобы не положить базу
    if (!$order) {
        $sleep_time = $EMPTY_LOOP_SLEEP;
    } else {
        $sleep_time = min(Time::HiRes::time() - $t1, $EMPTY_LOOP_SLEEP);
    }
}


1;
