#!/usr/bin/perl

=head1 NAME

    get_metro_js.pl

=head1 DESCRIPTION

    $Id:$
    Скрипт для генерации metro.js на основе данных, которые генерирует mk_regions.pl (geo_regions.pm)

=cut

use strict;
use warnings;

use my_inc '../..';

use File::Slurp;

use ScriptHelper;

use Settings;
use JSON;
use geo_regions;
use Encode;

my $metro_js = q/window["metro.js"](/;

my $data;
for my $city_id (keys %geo_regions::METRO) {
    my $name = $city_id == $geo_regions::MSK_REGION ?
        $geo_regions::GEOREG{$geo_regions::MOSCOW}{name} :
        $geo_regions::GEOREG{$city_id}{name}; # Меняем "Москва и Область" -> "Москва"
    push @$data, {
            city_id => $city_id,
            city    => $name,
            metro   => $geo_regions::METRO{$city_id},
        };
}

$metro_js .= to_json($data, {pretty => 0}). ");\n";

write_file("$Settings::ROOT/data/metro.js", {atomic => 1}, Encode::encode_utf8($metro_js));
write_file("$Settings::ROOT/data3/desktop.blocks/i-utils/__subway-station/i-utils__subway-station.data.js", {atomic => 1}, Encode::encode_utf8($metro_js));
