#!/usr/bin/perl

=head1 NAME

    js_translation.pl

=head1 DESCRIPTION

    Генерация статичных js-файлов переводов из block/i-translation/i-translation.tt2

=cut

use strict;
use warnings;

use my_inc '../..';

use File::Slurp;
use Settings;
use Template;
use TextTools qw/js_quote/;
use Yandex::I18n;

use open ':std' => ':utf8';
use utf8;


my $tt = Template->new(
    {
        ABSOLUTE => 1,
        POST_CHOMP => 0,
        PRE_CHOMP => 0,
        PRE_DEFINE => {
            iget => \&iget,
        },
        FILTERS => {
            js => \&js_quote,
        }
    }
) || die $Template::ERROR;

my $template = read_file "$Settings::ROOT/data/block/i-translation/i-translation.tt2", binmode => ':utf8';
for my $lang (Yandex::I18n::get_other_langs())  {
    Yandex::I18n::init_i18n($lang, check_file => 1);
    my $content;
    $tt->process(\$template, {}, \$content) or die $tt->error.'';

    write_file("$Settings::ROOT/data/block/i-translation/i-translation_lang_$lang.js", {atomic => 1, binmode => ':utf8'}, $content);
}
