#!/usr/bin/perl

=head1 DESCRIPTION

 make_custom_js_iget.pl - создание файла для последующей генерации клиентсайдовых
 переводов. Запускать руками при каждом изменении в описании валют.

=head1 SEE ALSO

 https://st.yandex-team.ru/DIRECTSUP-17935#1415794737000
 data/text/README.txt

=cut

use strict;
use warnings;
use utf8;
use open ':std' => ':utf8';

use my_inc '../..';

use Settings;
use Currencies;
use Currency::Texts ();
use BannerFlags qw//;
use List::MoreUtils qw/uniq/;

sub export_currencies_to_js
{
    my $const = Currencies::get_consts_for_js();
    my $texts_description = Currency::Texts::get_currency_texts_description_for_js();

    my $js = '';

    $js .= qq#/* autogenerated by $0
Для того, чтобы в js работала функция format_currency, которая внутри зовет
iget("евро") (или другая валюта), нужно чтобы слово "евро" было в файле
i-translation.tt2. Слова в этот файл попадают с помощью скрипта
generate_tt_html_from_js.pl, который ищет во всех js файлах строчки iget("whatever")

В этом файле мы подсовываем этому скрипту все имена валют,
а также валюто-зависимые строки.

***** Любые изменения в этом файле будут утеряны при перезапуске скрипта ******
***** Чтобы поменять что-то в этом файле, редактируйте protected/prebuild/make_custom_js_iget.pl *****
*/\n\n#;

    my @igets;
    for my $cur (keys %$const) {
        for my $field (qw/name full_name/) {
            push @igets, qq#iget("$const->{$cur}{$field}")#;
        }
    }
    for my $text_key (keys %$texts_description) {
        for my $cur (keys %{ $texts_description->{$text_key} }) {
            my $text_value = $texts_description->{$text_key}->{$cur};
            next unless $text_value;
            push @igets, qq#iget("$text_value")#
        }
    }
    @igets = uniq sort @igets;
    $js .= join ";\n", @igets, '';

    return $js;
}

sub export_ad_warnings_to_js
{
    my @igets = ();
    my $js = '';

    $js .= qq#/* autogenerated by $0

Переводы строк из BannerFlags::AD_WARNINGS

***** Любые изменения в этом файле будут утеряны при перезапуске скрипта ******
***** Чтобы поменять что-то в этом файле, редактируйте protected/prebuild/make_custom_js_iget.pl *****
*/\n\n#;
    for my $flag (sort keys %BannerFlags::AD_WARNINGS) {
        for my $k (qw/short_text long_text/) {
            my $str = $BannerFlags::AD_WARNINGS{$flag}{$k};
            next unless $str;
            push @igets, qq#iget("$str");#;
        }
    }
    $js .= join "\n", @igets;

    return $js;
}

sub write_js
{
    my ($fn, $js) = @_;
    open my $F, ">", $fn or die "$fn: $!";
    print $F $js;
    close $F;
}

write_js("$Settings::ROOT/data/text/currencies_iget.js", export_currencies_to_js());
write_js("$Settings::ROOT/data/text/ad_warnings_iget.js", export_ad_warnings_to_js());

