#!/usr/bin/perl

# $Id$
=pod
    
    Создание разных версий WSDL для API по шаблону

=cut

use warnings;
use strict;
use my_inc '../..';
use my_inc '../../', for => 'api/services/v5';

use Template;
use File::Slurp;
use File::Path qw(make_path remove_tree);

use Settings;
use ScriptHelper get_file_lock => undef, script_timer => undef;

my ($testing, $sandbox, $base_path, $debug, $createall, $is_beta) = (0, 0, $Settings::ROOT, 0,0);
my $hostname;

my %SKIP_ON_PRODUCTION = (
    map { $_ => 1 }
    # Дописываем сюда имена файлов которые нехотим создавать на продакшне
    # для закрашивания сервисов (работает только для API5 и выше)
    qw/
    /
);

extract_script_params(
    'testing' => \$testing,
    'sandbox' => \$sandbox,
    'hostname=s' => \$hostname,
    'debug' => \$debug,
    'base-path=s' => \$base_path,
    'createall' => \$createall,
    'beta' => \$is_beta,
);
if (!defined $hostname) {
    $hostname = $testing ? $Settings::API_SERVER_PATH_TEST : $Settings::API_SERVER_PATH;
    if ($sandbox) {
        $hostname = $Settings::API_SERVER_PATH_SANDBOX;
    }
}

my $tmpl_file = "$Settings::ROOT/data/t/api.tmpl.wsdl";
my $out_dir = "$base_path/data/soap-root";

my @files = ();
foreach my $version_label (keys %Settings::AVAILABLE_API_VERSIONS) {

  my ($api_version, $latest_suffix) = $version_label =~ (/^(\d+)\-?(\w+)*$/);

  foreach my $latest_flag (0..1) {
      next if !$latest_suffix && $latest_flag;
    my $latest = $latest_flag ? 'live' : '';
    my ($fname, $fname_test) = ("$out_dir/api-${api_version}${latest}.wsdl", "$out_dir/api-${api_version}${latest}-test.wsdl");
    if ($testing && !$sandbox){
        $fname .= ".test";
        $fname_test .= ".test";
        push @files, {file => $fname, api_version => $api_version, latest => $latest};
        push @files, {file => $fname_test, api_version => $api_version, test => 1, latest => $latest};
    } elsif ($sandbox && !$testing){
        $fname .= ".sandbox";
        if ( $createall || ! $Settings::AVAILABLE_API_VERSIONS{$api_version}{hidden} ) {
            push @files, {file => $fname, api_version => $api_version, test => $is_beta, latest => $latest};
        }
    } elsif ($testing && $sandbox){
        $fname .= ".sandbox.test";
        $fname_test .= ".sandbox.test";
        push @files, {file => $fname, api_version => $api_version, latest => $latest};
        push @files, {file => $fname_test, api_version => $api_version, test => 1, latest => $latest};
    } else {
        if ( $createall || ! $Settings::AVAILABLE_API_VERSIONS{$api_version}{hidden} ) {
            push @files, {file => $fname, api_version => $api_version, test => $is_beta, latest => $latest};
        }
    }
  }
}

# удаляем прежние версии wsdl-файлов, если такие остались
my @old_wsdl_files = read_dir($out_dir);
foreach my $f (@old_wsdl_files) {
    if ($f && $f =~ /^api(?:\-[\d\.]+)?\.wsdl(?:\.test)?$/) {
        unlink "$out_dir/$f";
        print STDERR "unlink $out_dir/$f\n" if $debug;
    }
}

# создаем новые версии
my $t = Template->new(ABSOLUTE => 1);
for my $f (@files) {
    my $cont = '';
    
    $t->process($tmpl_file, {api_version => $f->{api_version}
                                , latest => $f->{latest}
                                , test => $f->{test}
                                , lang => 'ru'
                                , API_SERVER_PATH => "https://".$hostname
                            }, \$cont) or die "Can't prebuild API wsdl ($f->{file}): ".$t->error();
    
    print STDERR "write file $f->{file}\n" if $debug;

    # удаляем пустые строки и пробелы в конце строк
    $cont = _file_minimizer($cont);

    write_file($f->{file}, {atomic => 1}, $cont);
}

# удаляем прежние версии wsdl-файлов (v5+)
# remove_tree($out_dir.'/wsdl');
# Не удаляем, чтобы не получить в этом мести гонки. Получаем проблему со
# старыми файлами, которая лечится пересозданием беты, что для дев. среды
# вполне нормально.

# здесь и ниже можно переписать на итерирование по версиям
eval {
    # пробуем создать, если еще не создано (на случай первого запуска)
    make_path($out_dir.'/wsdl/v5')
};

# создаем новые версии
my $template_path = "$Settings::ROOT/api/wsdl/v5/";
my @template_files = read_dir($template_path);
for my $f (@template_files) {
    my $cont = '';

    next if !$testing && !$is_beta && $SKIP_ON_PRODUCTION{$f};

    $t->process($template_path.'/'.$f, {api_version => 5
                                , is_beta => $is_beta
                                , lang => 'ru'
                                , API_SERVER_PATH => "https://".$hostname
                            }, \$cont) or die "Can't prebuild API wsdl ($f): ".$t->error();

    print STDERR "write file $f\n" if $debug;

    # удаляем пустые строки и пробелы в конце строк
    $cont = _file_minimizer($cont);

    my $out_file = $f;
    if ($testing && !$sandbox) {
        $out_file .= '.test';
    } elsif ($sandbox && !$testing){
        $out_file .= ".sandbox";
    } elsif ($testing && $sandbox){
        $out_file .= ".sandbox.test";
    }
    write_file($out_dir.'/wsdl/v5/'.lc($out_file), {atomic => 1}, $cont);
    if ($is_beta) {
        $cont = '';

        $t->process($template_path.'/'.$f, {api_version => 5
                                    , lang => 'ru'
                                    , API_SERVER_PATH => "https://".$hostname
                                    , json_text => 1
                                }, \$cont) or warn "Can't prebuild API wsdl ($f): ".$t->error();
        $f =~ s/\..*//;
        $f.= '.xml';
        print STDERR "write file $f\n" if $debug;

        # удаляем пустые строки и пробелы в конце строк и добавляем вторую строку
        $cont = _file_evilizer($cont);

        write_file($out_dir.'/wsdl/v5/'.lc($f), {atomic => 1}, $cont);
    }
}

sub _file_minimizer
{
    my $text = shift;
    
    # удаляем пустые строки
    my @pure_cont = ();
    foreach my $row (split /[\n\r]+/, $text) {
        next if $row =~ /^\s+$/;

        # удаляем пробелы в конце строк
        $row =~ s/\s+$//g;

        push @pure_cont, $row;
    }
    
    return join("\n", @pure_cont);
}

sub _file_evilizer
{
    my $text = shift;
    
    # удаляем пустые строки
    my @pure_cont = ();

    ## no critic (Freenode::DollarAB)
    my $a = 0;
    foreach my $row (split /[\n\r]+/, $text) {
        next if $row =~ /^\s+$/;

        # удаляем пробелы в конце строк
        $row =~ s/\s+$//g;

        push @pure_cont, $row;
        push @pure_cont, q!<?xml-stylesheet type="text/xsl" href="/api/v5?template"?>! unless ($a);
        $a = 1;
    }
    
    return join("\n", @pure_cont);
}
