#!/usr/bin/perl

use my_inc "..";

=head1 METADATA

<juggler>
    from_file: stopwords_freshness.yml
</juggler>

=cut

=head1 NAME

    refreshStopWordsMonitor.pl - проверка успехов работы скрипта refreshStopWords.pl

=head1 DESCRIPTION

    Смотрит на дату изменения файла со стоп-словами и сообщает об ошибке, если файл обновлялся больше суток назад.
    Скрипт запускается вместе с refreshStopWords.pl по кронтабу в пакете yandex-direct

=cut

use Direct::Modern;

use Yandex::StopWords qw/$STOP_WORDS_AUTOREFRESH_FILE/;
use ScriptHelper 'Yandex::Log' => 'messages';

use File::stat;

my $MAX_FILE_AGE = 24 * 60 * 60;
my $SERVICE_NAME = "direct.refreshStopWords.working";

$log->out('START');
my $st = stat($STOP_WORDS_AUTOREFRESH_FILE);
if (defined $st) {
    my $file_age = time - $st->[9];

    $log->out("$STOP_WORDS_AUTOREFRESH_FILE age is $file_age seconds");
    if ($file_age < $MAX_FILE_AGE) {
        juggler_ok(service => $SERVICE_NAME);
    } else {
        $log->out("$STOP_WORDS_AUTOREFRESH_FILE is too old");
        juggler_crit(
            service => $SERVICE_NAME,
            description => "Stop words file age is more than $MAX_FILE_AGE seconds ($file_age)",
        );
    }
} else {
    $log->out("$STOP_WORDS_AUTOREFRESH_FILE does not exist");
    juggler_crit(
        service => $SERVICE_NAME,
        description => "Stop words file does not exist",
    );
}

juggler_ok();
$log->out('FINISH');
