#!/usr/bin/perl

use my_inc "..";


=head1 METADATA

<crontab>
    time: 30 1 * * *
    package: scripts-sandbox
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    name:           scripts.sandbox_clean_old_users.working.sandbox
    raw_host:       CGROUP%direct_sandbox
    raw_events:     scripts.sandbox_clean_old_users.working.sandbox
    ttl:            2d4h
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 DESCRIPTION

    $Id$
    Удаление неактивных пользователей из песочницы за последние n дней

    Скрипт выключен, в пользу https://st.yandex-team.ru/DIRECT-74742
    Удалять его пока нестали, для истории и в случае если предыдущий тикет не срастется

=cut

use Direct::Modern;

#use POSIX qw/strftime/;
#use List::MoreUtils qw/uniq/;

use ScriptHelper;

use Settings;

#use Yandex::DBTools;
#use RBACElementary;
#use SandboxCommon;
use EnvTools;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

$SIG{__WARN__} = sub {
    # если не внутри eval или $log->warn,
    if (defined $^S && !$^S) {
        my $msg = Carp::longmess(@_);
        $log->out("WARN: $msg")  if $msg !~ 'Yandex::Log::warn';
    }
};

if (!is_sandbox()) {
    $log->out("started not in sandbox");
    die("sandbox_clean_old_users: started not in sandbox");
}

$log->out("start");
$log->out("script disabled, check DIRECT-74742");
=off
my $rbac = RBAC2::Extended->get_singleton(1);

# через сколько дней неактивности удаляем пользователей
my $REMOVE_OLD_USERS_INTERVAL = 30; #days

my $search_data = {};

for (my $day = 0; $day < $REMOVE_OLD_USERS_INTERVAL; $day++) {
    my $date = strftime("%Y%m%d", localtime(time() - $day*60*60*24));
    my $table_name = "logapi_users_".substr($date, 0, 6);

    push @{$search_data->{$table_name}}, $date;
}

# ищем пользователей песочницы за последние $REMOVE_OLD_USERS_INTERVAL дней
my $current_users = [];

foreach my $table_name (keys %$search_data) {
    next unless is_table_exists(PPCLOG_HEAVY, $table_name);

    my $result = get_one_column_sql(PPCLOG_HEAVY, [ "select distinct operator_uid from $table_name",
                                            where => { operator_uid__gt => 0, date => $search_data->{$table_name}}]) || [];
    push @$current_users, @$result if $result;
}
$current_users = [uniq @$current_users];

$log->die("no active users for last $REMOVE_OLD_USERS_INTERVAL days") unless @$current_users;

# ищем всех пользователей в базе песочницы, созданных более $REMOVE_OLD_USERS_INTERVAL 
# дней назад, или не пользовавшихся песочницей за этот период
my $border_createtime = time() - $REMOVE_OLD_USERS_INTERVAL*60*60*24;
my $users_to_del = get_one_column_sql(PPC, ['select uid from users', where => {uid__lt => 1000000000, uid__not_in => $current_users, createtime__lt => $border_createtime }]) || [];

if (@$users_to_del) {
    # фильтруем пользователей по роли
    my $users_to_del_roles = rbac_multi_who_is($rbac, $users_to_del);
    my @del_uids = grep {$users_to_del_roles->{$_} =~ /(empty|client|agency)/} keys %$users_to_del_roles;
    $log->out("found ".(scalar @del_uids)." uids to remove from sandbox");
    foreach my $uid (@del_uids) {
        if (drop_sandbox_user($rbac, $uid)) {
            $log->out("user with uid $uid removed from all bases");
        }
    }
} else {
    $log->out("found 0 uids to remove from sandbox");
}

=cut
juggler_ok(service_suffix => 'sandbox');

$log->out("finish");

