#!/usr/bin/perl

use my_inc "..";


=head1 METADATA

<crontab>
    time: */30 * * * *
    package: scripts-sandbox
</crontab>

=cut

=head1 DESCRIPTION

    $Id$
    Скрипт для генерации фэйковой статистики по кампаниям

=cut

use warnings;
use strict;
use POSIX qw/strftime/;

use ScriptHelper get_file_lock => ['dont die'];

use Settings;

use Yandex::DBTools;
use List::Util qw/max/;

use SandboxCommon;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my $SCRIPT_NAME = get_script_name();

$log->out("start script $SCRIPT_NAME");

my $limit = 10000;
my $cur_order_id = 0;

my $cur_date = strftime('%Y%m%d', localtime());

my $today_orders = get_hashes_hash_sql(PPC, ['select distinct OrderID from bs_auction_stat join phrases using(pid) join campaigns using(cid)', where => {stattime => $cur_date}]);

my %PageID2TargetType = map {$_->{PageID} => $_->{TargetType} > 3 ? 1 : $_->{TargetType}} values %{get_pages_for_fake_stat()};

my $where = {statusActive => 'Yes'};

my $order_sum_stat;

while (1) {
    $where->{OrderID__gt} = $cur_order_id;
    my $orders = get_one_column_sql(PPC, [ 'select OrderID from campaigns',  where => $where, "limit $limit" ]) || [];

    last if ! @$orders;
    if (my $reason = smart_check_stop_file()) {
        $log->out("$reason. Let's finish!");
        last;
    }

    $cur_order_id = max(@$orders);

    my $data_bs_auction_stat = [];

    foreach my $order_id (@$orders) {

        next if $today_orders->{$order_id};

        $log->out("generate stat for order $order_id");

        my $report_params = {
            order_ids  => [$order_id],
            date_from => $cur_date,
            date_to   => $cur_date,
            group_by   => [qw/BannerID PhraseID PageID TypeID GroupExportID/],
        };
        my $stat = get_fake_master_report_stat($report_params);

        my $sum_stat = {};

        $sum_stat->{order}{shows} = $stat->{totals}->{Shows};
        $sum_stat->{order}{clicks} = $stat->{totals}->{Clicks};
        $sum_stat->{order}{sum} = $stat->{totals}->{Cost};

        for my $i (@{$stat->{data}}) {
            my %stat_row;
            @stat_row{@{$stat->{header}}} = @$i;

            my $BannerID     = $stat_row{BannerID};
            my $PhraseID     = $stat_row{PhraseID};
            my $PageID       = $stat_row{PageGroupID};
            my $TypeID       = $stat_row{TypeID};
            my $shows        = $stat_row{Shows};
            my $clicks       = $stat_row{Clicks};
            my $pid          = $stat_row{GroupExportID};

            if ($PageID2TargetType{$PageID} != 3) {
                my $stat = $sum_stat->{bs_auction_stat}{$pid}{$PhraseID} ||= {};
                $stat->{shows} += $shows;
                $stat->{clicks} += $clicks;
                $stat->{pshows} += $TypeID == 1 ? $shows : 0;
                $stat->{pclicks} += $TypeID == 1 ? $clicks : 0;
            }
        }

        if (keys %$sum_stat) {

            while(my($pid, $data) = each %{$sum_stat->{bs_auction_stat}}) {
                while(my($PhraseID, $phrase_data) = each %{$data}) {
                    push @$data_bs_auction_stat, [$pid, $PhraseID, $phrase_data->{shows}, $phrase_data->{clicks}, 1, $phrase_data->{pshows}, $phrase_data->{pclicks}, $cur_date];
                }
            }

            $order_sum_stat->{$order_id} = $sum_stat->{order};
        }
    }

    if (@$data_bs_auction_stat) {
        do_mass_insert_sql(PPC, 'INSERT INTO bs_auction_stat
                                                    (pid, phraseid, shows, clicks, rank, pshows, pclicks, stattime) values %s
                                                    on duplicate key update shows=values(shows), clicks=values(clicks), rank=values(rank), 
                                                    pshows=values(pshows), pclicks=values(pclicks), stattime=values(stattime)', 
                                                    $data_bs_auction_stat);
    }
}

if (scalar keys %$order_sum_stat) {
    
    $log->out("update shows, clicks and sum for orders");
    $log->out([keys %$order_sum_stat]);

    my $order_id2sum_rest = get_hashes_hash_sql(PPC, ['select OrderID, sum - sum_spent as sum_rest from campaigns', where => {OrderID => [keys %$order_sum_stat]}]);
    # на случай гонок, когда кампанию успели удалить до вычисления $order_id2sum_rest
    my @order_ids = sort keys %$order_id2sum_rest;
    # обновляем клики, показы и сумму денег на кампании, а так же statusActive, если кампания отключилась по деньгам
    my $ct_case = "case OrderID ".join(' ', map { "when $_ then sum_spent + if($order_sum_stat->{$_}->{sum} > $order_id2sum_rest->{$_}{sum_rest}, $order_id2sum_rest->{$_}{sum_rest}, $order_sum_stat->{$_}->{sum})" } @order_ids )." else sum_spent end\n";
    my $SQL = "UPDATE campaigns c SET \n";
    $SQL .= " sum_spent = $ct_case, sum_spent_units = $ct_case, start_time=start_time\n";
    $SQL .= ", shows = case OrderID ".join(' ', map { "when $_ then IF(shows is null, 0, shows) + $order_sum_stat->{$_}->{shows}" } @order_ids)." else shows end\n";
    $SQL .= ", clicks = case OrderID ".join(' ', map { "when $_ then IF(clicks is null, 0, clicks) + $order_sum_stat->{$_}->{clicks}" } @order_ids)." else clicks end\n";
    $SQL .= ", statusActive = case OrderID ".join(' ', map { "when $_ then if($order_sum_stat->{$_}->{sum} > $order_id2sum_rest->{$_}{sum_rest}, 'No', statusActive)" } @order_ids)." else statusActive end\n";
    $SQL .= "WHERE OrderID in ( ".join(',', @order_ids)." )\n";

    do_sql(PPC, $SQL);
}

$log->out("stop script $SCRIPT_NAME");
