#!/usr/bin/perl

use my_inc "..";

=head1 METADATA

<crontab>
    time: */5 * * * *
    package: scripts-sandbox
</crontab>

<juggler>
    host:   checks_auto.direct.yandex.ru
    raw_host:     CGROUP%direct_ng_soaps_sandbox_prod
    ttl:          15m
    tag: direct_group_internal_systems
</juggler>

=cut

=head1 DESCRIPTION

    $Id$
    Скрипт для обработки очереди картинок на «скачивание» в песочнице

=cut

use warnings;
use strict;
use utf8;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::DBQueue;

use Settings;
use ScriptHelper;

use HashingTools qw/md5_base64ya/;

extract_script_params();

local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

$log->out("START");

$Yandex::DBQueue::LOG = $log;
my $queue = Yandex::DBQueue->new(PPC, 'banner_images');

my @jobs = $queue->grab_jobs(limit => 1000);

$log->out((scalar @jobs)." jobs in queue");

for my $job (@jobs) {
    if ($job->trycount > 4) {
        $job->mark_failed_permanently({ error => 'Unknown error' });
        next;
    }

    my $pool_id = get_new_id('banner_images_pool_id', ClientID => $job->ClientID);
    my $image_hash = md5_base64ya($job->args->{url});
    do_insert_into_table(PPC, 'banner_images_pool', {
        imp_id => $pool_id,
        image_hash => $image_hash,
        ClientID => $job->ClientID,
        name => $job->args->{name},
    }, on_duplicate_key_update => 1);
    $job->mark_finished({ image_hash => $image_hash, image_type => 'regular' });
}

$queue->delete_old_jobs(3600);

juggler_ok();

$log->out("finish");
