#!/usr/bin/perl

use my_inc "..";


=head1 METADATA

<crontab>
    time: */2 * * * *
    package: scripts-sandbox
</crontab>

=cut

=head1 DESCRIPTION

    $Id$
    Обновление статусов модерации кампаний и баннеров

=cut

use warnings;
use strict;

use ScriptHelper 'get_file_lock' => undef;

use List::MoreUtils qw/uniq/;

use Yandex::HashUtils;

use Settings;
use LockTools;
use RBAC2::Extended;
use Yandex::DBTools;

use SandboxCommon;
local $Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

my $SCRIPT_NAME = get_script_name();

get_file_lock('dont_die', "$SCRIPT_NAME.lock");

my $rbac = RBAC2::Extended->get_singleton(1);

$log->out("start daemon $SCRIPT_NAME");

while (1) {
    # обновляем статусы модерации Sent -> Yes
    my $bids_to_update = get_hashes_hash_sql(PPC, 'select b.bid, p.cid from campaigns c join banners b using (cid) left join phrases p using (pid)
                                                    where b.statusModerate = "Sent" or b.statusSitelinksModerate = "Sent"
                                                    or b.phoneflag = "Sent"
                                            ');

    hash_merge $bids_to_update, get_hashes_hash_sql(PPC, 'select b.bid, p.cid from campaigns c join banners b using (cid) left join phrases p using (pid)
                                                    where p.statusModerate = "Sent"
                                            ');

    $log->out("change status Sent -> Yes");
    $log->out(keys %$bids_to_update);

    if (scalar keys %$bids_to_update) {
        set_fake_status_moderate($rbac, 'Yes', [keys %$bids_to_update], [uniq map {$_->{cid}//()} values %$bids_to_update]);
    }

    # обновляем статусы модерации Ready -> Sent
    set_fake_status_moderate($rbac, 'Sent');

    $log->out("change status Ready -> Sent");

    # чистим универсальную очередь
    do_delete_from_table(PPC, 'moderation_cmd_queue', where => {id__gt => 0});

    if (my $reason = smart_check_stop_file()) {
        $log->out("$reason!");
        last;
    }

    sleep 60;
}

$log->out("stop daemon $SCRIPT_NAME");
