#!/usr/bin/perl

use my_inc "..";



=head1 METADATA

<crontab>
    time: */2 * * * *
    package: 
</crontab>
<juggler>
    from_file: sendAlert.yml
</juggler>
=cut

use warnings;
use strict;

use Fcntl ':flock';
use FileHandle;
use File::Slurp;
use Sys::Hostname;

use ScriptHelper;

use MailService;
use Settings;

use utf8;
use open ':std' => ':utf8';

my $MAX_BODY_SIZE = 100_000;
my $OUT_FILE = "$Settings::MONITOR_ROOT/alerts.num";

$log->out('START');

(my $hostname = hostname()) =~ s/\.yandex\.(ru|net)$//;

exit if !-f $Yandex::SendMail::SEND_ALERT_LOG;
open( LOCK, "<:encoding(utf8)", $Yandex::SendMail::SEND_ALERT_LOG ) or $log->die("Can't open logfile: $Yandex::SendMail::SEND_ALERT_LOG");
unless( flock( LOCK, LOCK_EX ) ) {
    $log->die('Error:sendAlert Skiped');
}

$log->out('reading alerts from file');

my %msg_hash = ();
my ( $subj, $body ) = ( '', '' );
my ( $sflag, $bflag  ) = ( 0, 0 );

while( my $row = <LOCK> ) {
    if( $row =~ /\#subject=(.*)/ ) {
        if( $body ne "" ) {
            push @{ $msg_hash{ $subj } }, $body;
            $body = ''; $subj = '';
        }
        $subj = $1;
    }

    if( $row =~ /\#body=(.*)/s ) {
        $body = $1;
    } elsif( $row !~ /\#subject=/ && $subj ne "" ) {
        $body .= $row;
    }

    push @{ $msg_hash{ $subj } }, $body if eof LOCK;
}

truncate $Yandex::SendMail::SEND_ALERT_LOG, 0;
flock LOCK, LOCK_UN;
close LOCK;

$log->out('sending emails');

my @mail_mass = ();
my $email = 'ppc-admin@yandex-team.ru';
my ($global_errnum, @global_msg) = (0);
foreach my $subj (sort {@{$msg_hash{$b}} <=> @{$msg_hash{$a}}} keys %msg_hash) {
    my $cnt = @{$msg_hash{$subj}};
    my $new_subj = $subj.( $cnt > 1 ? " x $cnt" : '' );
    my $new_body = join "----\n", @{$msg_hash{ $subj }};
    # если текст слишком длинный - подрезаем его
    if (length($new_body) > $MAX_BODY_SIZE) {
        $new_body = substr($new_body, 0, $MAX_BODY_SIZE / 2)
            . "\n\n ... full size: " . length($new_body) . " ... \n\n" 
            . substr($new_body, length($new_body) - $MAX_BODY_SIZE / 2);
    }
    sendmail_with_logging( $email, '"Yandex.PPC" <ppc-admin@yandex-team.ru>', "$hostname: $new_subj", \$new_body, 'text' );    

    $global_errnum += $cnt;
    push @global_msg, "$cnt x $subj";
}

write_file($OUT_FILE, {atomic => 1}, "$global_errnum\n".join(", ", @global_msg));
$log->out("processed $global_errnum alerts");

$log->out('FINISH');
