#!/usr/bin/perl

use warnings;
use strict;

use my_inc "..";

# Apache2 start-up.pl for intapi
# компиляция из Директового start-up.pl от apache1 и Геоконтекстового startup.pl

use Apache2::ServerRec ();
use Apache2::ServerUtil ();
use HTTP::Headers;

# нестандартная загрузка CGI унаследована целиком из protected/start-up.pl
# попытка обойти баг разбора multipart при включённом utf8 в CGI.pm 
BEGIN {
    require CGI;
    # заранее компилируем все функции из MultipartBuffer
    $CGI::AUTOLOAD = "MultipartBuffer::new";
    CGI::_compile();
    for my $name (grep {$_ ne 'new'} keys %MultipartBuffer::SUBS) {
        $CGI::AUTOLOAD = "MultipartBuffer::$name";
        CGI::_compile();
    }
};

# инициализация оригинальных написаний частых заголовков
# иначе, они могут проинициализироваться из ENV в верхнем регистре
HTTP::Headers->new('Cookie' => '', 'X-Real-IP' => '');

# временные файлы для разбора завпросов использовать не нужно,
# они не всегда удаляются, всё держим в памяти
require Plack::TempBuffer;
{
    no warnings 'once';
    $Plack::TempBuffer::MaxMemoryBufferSize = 1024 * 1024 * 1024;
}

umask 002;

# Tell me more about warnings
use Carp ();
use Yandex::CallerStack;
our $stack=Yandex::CallerStack->new();
$SIG{USR2} = sub {warn $stack->trace()};

use Settings;
use EnvTools;
#use Yandex::PerlIO::via::Truncate;

# запрещаем одному запросу генерить больше мегабайта error.log
#Yandex::PerlIO::via::Truncate::init(\*STDERR);

if (is_beta()) {
    $SIG{__WARN__} = sub {
        local $Carp::Internal{(__PACKAGE__)};
        $Carp::Internal{(__PACKAGE__)}++;
        local $Carp::MaxEvalLen = 2000;
        local $Carp::MaxArgLen = 100;
        Carp::cluck $_[0];
    };
}

1;
