# -*- coding: utf-8 -*-
"""Реализация механизма шардов в Директе"""
from __future__ import absolute_import
from sqlalchemy import MetaData, Table, Column
from sqlalchemy.dialects import mysql
from direct.db import db_engine

__all__ = [
    'get_new_id',
    'get_new_ids',
]

# Название базы данных с шардированными таблицами
SHARD_DB = 'ppcdict'

class schema(object):
    # Описание метаданных таблиц
    metadata = MetaData()
    inc_job_id = Table('inc_job_id', metadata,
        Column('job_id', mysql.BIGINT(20, unsigned=True), primary_key=True, autoincrement=True),
    )

# Название таблиц у ключей, для которых поддерживается автоинкремент
AUTOINCREMENT_KEYS = {
    'job_id': schema.inc_job_id,
}

def get_new_id(key):
    """Генерирует новое автоинкрементное значение для ключа key"""
    table = AUTOINCREMENT_KEYS.get(key)
    if table is None:
        raise KeyError('Key %r is not supported' % (key,))
    engine = db_engine(SHARD_DB)
    result = engine.execute(table.insert().values())
    return result.inserted_primary_key[0]

def get_new_ids(key, count):
    """Генерирует новые автоинкрементные значения для ключа key"""
    table = AUTOINCREMENT_KEYS.get(key)
    if table is None:
        raise KeyError('Key %r is not supported' % (key,))
    if count < 1:
        raise ValueError('Count must be a positive integer: %r' % (count,))
    ids = []
    sql_insert = table.insert().values()
    # Не имеет смысла разделять генерацию одного или нескольких ключей
    # По семантике DBAPI транзакция всё-равно начнётся, даже если мы не хотим
    engine = db_engine(SHARD_DB)
    with engine.begin() as conn:
        for _ in xrange(count):
            ids.append(conn.execute(sql_insert).inserted_primary_key[0])
    return ids
