#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
Оберточка для чтения новых записей об истории изменения фичей
"""

import sys
import os.path
from datetime import datetime, timedelta
import json

sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))
from direct.db import db_engine


PPCDICT_ENGINE = db_engine('ppcdict')


def read_with_handler(property_name, handler, diff=False):
    """
    Принимает на вход:
    1. Название проперти со временем последнего прочитанного изменения
    2. Функцию, которая будет что-то делать с новыми только что прочитанными изменениями
    Читает данные, если надо, то считает дифф измененной фичи, вызывает handler с ними и обновляет пропертю.
    """
    last_dt_result = PPCDICT_ENGINE.execute(
        "SELECT value FROM ppc_properties WHERE name='%s'" % property_name
    ).fetchall()

    last_dt_value = ((datetime.now() - timedelta(days=1)).strftime("%Y-%m-%d %H:%M:%S")
                    if not last_dt_result or not last_dt_result[0] or not last_dt_result[0][0]
                    else last_dt_result[0][0])

    select_fields = [
        "id", "event_time", "event_type", "feature_id", "feature_text_id", "new_settings", "operator_uid", "reqid"
    ]
    new_changes = PPCDICT_ENGINE.execute(
        """
        SELECT %s
        FROM features_history
        WHERE event_time > '%s'
        ORDER BY event_time
        """ % (",".join(select_fields), last_dt_value)
    ).fetchall()

    if not new_changes:
        return

    new_changes = [{field: change[idx] for idx, field in enumerate(select_fields)} for change in new_changes]

    if diff:
        build_diff(new_changes, last_dt_value)

    handler(new_changes)

    if not last_dt_result:
        PPCDICT_ENGINE.execute(
            "INSERT INTO ppc_properties (name, value) VALUES ('%s', '%s')" % (
                property_name, new_changes[-1]['event_time']
            )
        )
    else:
        PPCDICT_ENGINE.execute(
            "UPDATE ppc_properties SET value='%s' WHERE name='%s'" % (
                new_changes[-1]['event_time'], property_name
            )
        )


def get_uid2login(uids):
    """
    Из списка uid'ов получаем dict: uid -> login
    """
    return {
        uid: login for login, uid in PPCDICT_ENGINE.execute(
            "SELECT login, uid FROM shard_login WHERE uid IN (%s)" % ",".join(uids)
        )
    }


def get_previous_settings(feature_ids, last_dt_value):
    """
    возвращает dict: feture_id -> previous_settings
    """
    return {
        feature_id: settings for feature_id, settings in PPCDICT_ENGINE.execute(
            """
            SELECT fh1.feature_id, fh1.new_settings
            FROM features_history fh1
            JOIN (
                SELECT feature_id, MAX(event_time) event_time
                FROM features_history
                WHERE event_time <= '%s'
                GROUP BY feature_id
            ) fh2 ON fh1.feature_id = fh2.feature_id AND fh1.event_time = fh2.event_time
            WHERE fh1.feature_id IN (%s)
            """ % (last_dt_value, ",".join(["'%s'" % feature_id for feature_id in feature_ids]))
        )
    }


def build_diff(changes, last_dt_value):
    """
    Строим удобный дифф настроек фич своими руками
    """
    feature_ids = set(change['feature_id'] for change in changes)

    previous_settings_by_id = {
        feature_id: json.loads(settings)
        for feature_id, settings in get_previous_settings(feature_ids, last_dt_value).items()
    }
    previous_settings_by_id.update([
        (feature_id, {})
        for feature_id in feature_ids if feature_id not in previous_settings_by_id]
    )

    for change in changes:
        prev_settings = previous_settings_by_id[change['feature_id']]
        new_settings = json.loads(change['new_settings'])

        diff = []
        for field in new_settings:
            if field in prev_settings:
                if isinstance(new_settings[field], list) and isinstance(prev_settings[field], list):
                    if set(new_settings[field]) != set(prev_settings[field]):
                        diff.append(u"%s: %s -> %s (изменено)" % (
                            field, str(sorted(prev_settings[field])), str(sorted(new_settings[field]))
                        ))
                    else:
                        pass
                elif str(new_settings[field]) != str(prev_settings[field]):
                    diff.append(u"%s: %s -> %s (изменено)" % (field, str(prev_settings[field]), str(new_settings[field])))

        for field in new_settings:
            if field not in prev_settings:
                diff.append(u"+%s: %s (добавлено)" % (field, str(new_settings[field])))

        for field in prev_settings:
            if field not in new_settings:
                diff.append(u"-%s: %s (удалено)" % (field, str(prev_settings[field])))

        change['diff'] = u"\n".join(diff)
        previous_settings_by_id[change['feature_id']] = new_settings

