# -*- encoding: utf-8 -*-
"""
SQLAlchemy модели табличек, относящихся к ppcdict
"""

from __future__ import absolute_import

from sqlalchemy import *
from sqlalchemy.orm import relation, backref
from sqlalchemy.ext.declarative import declarative_base

from sqlalchemy.dialects.mysql import SMALLINT

from datetime import date

import direct.db

__all__ = ['PpcProperties']

Base = declarative_base()
Base.metadata.bind = direct.db.db_engine('ppcdict')
schema = 'ppcdict'

class PpcProperties(Base):
    __tablename__ = 'ppc_properties'
    __table_args__ = {'schema': schema}
    name = Column(String(50), primary_key=True)
    value = Column(Text())
    def __init__(self, name, value=None):
        self.name = name
        self.value = value
    def __repr__(self):
       return "<PpcProperties ('%s', '%s')>" % (self.name, self.value)

