# -*- encoding: utf-8 -*-
"""
Сборник небольших функций, специфичных для Директа
"""

from __future__ import absolute_import

import yaml
import sys, os, os.path
import logging
from datetime import date
from direct.tracing import Trace
from direct.logging import DateTimeSuffixedFileHandler

import settings

def direct_hosts():
    """
    Получить структуру с информацией о серверах Директа
    { 'frontends': ['ci5', ...], ... }
    """
    hosts_file = os.path.join(settings.ROOT, 'etc', 'hosts')
    return yaml.load(open(hosts_file, "r"))


def set_logging(filename=None, loglevel=logging.INFO, add_info=''):
    """
    Настроить логгирование в файл, имя файла по-умолчанию - имя скрипта
    """
    if filename is None:
        filename = os.path.basename( os.path.splitext(sys.argv[0])[0] )

    if not isinstance(loglevel, int):
        loglevel = getattr(logging, loglevel)

    logging.basicConfig(
        level=loglevel,
        filename="{root}/{name}.{ymd}".format(root=settings.LOG_ROOT, name=filename, ymd=date.today().strftime("%Y%m%d")),
        format='%(asctime)-15s %(levelname)s [%(process)s/{}] %(message)s'.format(add_info),
    )

    yt_logger = logging.getLogger("Yt")
    yt_logger.propagate = True
    yt_logger.setLevel(loglevel)
    for h in yt_logger.handlers:
        yt_logger.removeHandler(h)

    trace_logger = logging.getLogger("Tracing")
    trace_logger.propagate = False
    trace_logger.addHandler(DateTimeSuffixedFileHandler(settings.LOG_ROOT + "/" + "trace.log"))


class MyTrace(Trace):
    def __exit__(self, exc_type, exc_value, exc_traceback):
        json_line = self.to_json()
        if json_line is not None:
            logging.getLogger("Tracing").critical(json_line)
