#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" METADATA

<crontab>
    env: YT_DIRECT_CLUSTER=hahn
    params: --force
    time: 42 1,8 * * *
    <switchman>
        lockname: cleanup_yt_tmp.py.hahn
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    name:       scripts.cleanup_yt_tmp.working.hahn
    raw_events: scripts.cleanup_yt_tmp.working.hahn
    ttl:        2d2h
    tag:        direct_yt
    tag: direct_group_internal_systems
</juggler>

<crontab>
    env: YT_DIRECT_CLUSTER=arnold
    params: --force
    time: 42 1,8 * * *
    <switchman>
        lockname: cleanup_yt_tmp.py.arnold
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    name:       scripts.cleanup_yt_tmp.working.arnold
    raw_events: scripts.cleanup_yt_tmp.working.arnold
    ttl:        2d2h
    tag:        direct_yt
    tag: direct_group_internal_systems
</juggler>

<crontab>
    env: YT_DIRECT_CLUSTER=arnold-dev
    params: --force --path "" --skip-path-check
    time: 37 2,6 * * *
    <switchman>
        lockname: cleanup_yt_tmp.py.arnold_dev
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    name:       scripts.cleanup_yt_tmp.working.arnold-dev
    raw_events: scripts.cleanup_yt_tmp.working.arnold-dev
    ttl:        2d2h
    tag:        direct_yt
    tag: direct_group_internal_systems
</juggler>


<crontab>
    env: YT_DIRECT_CLUSTER=freud
    params: --force --days 21
    time: 42 1,8 * * *
    <switchman>
        lockname: cleanup_yt_tmp.py.freud
        group: scripts-other
    </switchman>
    package: scripts-switchman
</crontab>
<juggler>
    host:   checks_auto.direct.yandex.ru
    name:       scripts.cleanup_yt_tmp.working.freud
    raw_events: scripts.cleanup_yt_tmp.working.freud
    ttl:        2d2h
    tag:        direct_yt
    tag: direct_group_internal_systems
</juggler>

"""

"""
Очистка директории tmp
"""

import datetime
import sys, os.path
import argparse
import logging

sys.path[0:0] = [os.path.realpath(os.path.join(os.path.dirname(__file__), ".."))]

import settings
from yandex.utils import *
from yandex.juggler import juggler_queue_event
from direct.ytutils import YT_PREFIX, cleanup_yt_dir
import direct.tools

import yt.wrapper as yt

DEFAULT_DAYS_AGO=7
DEFAULT_LOG_LEVEL = 'warn'

if __name__ == '__main__':

    parser = argparse.ArgumentParser(description='Cleanup tmp directory in yt cluster')
    parser.add_argument('--force', nargs='?', const=True, default=False, help='force table removing (not only print)')
    parser.add_argument('--days', type=int, nargs='?', default=DEFAULT_DAYS_AGO, help='days without access before removing')
    parser.add_argument('--path', type=str, default='tmp', help='relative path for cleaning (needs to starts with "tmp")')
    parser.add_argument('--log', type=str, default=DEFAULT_LOG_LEVEL, help='log level')
    parser.add_argument('--skip-path-check', action='store_true', help='allows to cleanup not only temporary folders')
    args = parser.parse_args()
    direct.tools.set_logging(loglevel=args.log.upper(), add_info=os.environ.get('YT_PROXY', '-'))

    if not args.path.startswith('tmp') and not args.skip_path_check:
        logging.error("Incorrect path")
        sys.exit(1)

    border_time = datetime.datetime.now() - datetime.timedelta(days=args.days)
    
    if len(args.path) == 0:
        root_path = YT_PREFIX[0:-1]
    else:
        root_path = YT_PREFIX + args.path
    logging.warn("start with path %s, border_time: %s" % (root_path, border_time))
    cleanup_yt_dir(root_path, border_time, force=args.force)
    juggler_queue_event('scripts.cleanup_yt_tmp.working.' + os.environ.get('YT_DIRECT_CLUSTER', 'prod'), 'OK', 'Cleaned tmp directory')
            
