#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" METADATA

<crontab>
    time: 0 10 * * *
    <switchman>
        lockname: features_history_notify.py
        group: scripts-other
        delay: 3
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    time: */10 9-20 * * *
    <switchman>
        lockname: features_history_notify.py
        group: scripts-test
        delay: 3
    </switchman>
    package: conf-test-scripts
</crontab>
<juggler>
    host:       direct.prod_javaperl
    name:       scripts.features_history_notify.working
    raw_events: scripts.features_history_notify.working
    ttl:        1d12h
    tag:        directadmin_TV
</juggler>

"""

"""
Отправляем в релизный чат историю изменения фичей
"""

import sys
import os.path
import logging
from datetime import datetime, timedelta

sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))
from yandex.juggler import juggler_queue_event
from direct.tools import set_logging
import settings
import direct.features_history_reader as features_history_reader

sys.path.insert(0, '/opt/direct-chat-bot')
from bots import TelegramBot
from bot_commands import MessageContentTypes


SERVICE_NAME = 'scripts.features_history_notify.working'
PROPERTY_NAME = 'features_history_notify.last_event_datetime'
BOT_CONFIG = '/etc/direct-chat-bot/telegram.yaml'
CONF_TO_CHAT_ID = {
    'production': '-1001072994247', # direct-release чат в телеграмме
    'test': '-492107972' # DNA Test Duty чат в телеграмме
}


def new_changes_handler(new_changes):
    features2changes = {}
    for change in new_changes:
        if change['feature_id'] not in features2changes:
            features2changes[change['feature_id']] = []

        features2changes[change['feature_id']].append(change)

    uid2login = features_history_reader.get_uid2login(set(str(change['operator_uid']) for change in new_changes))

    featuresid2text = {}
    for feature_id in features2changes.keys():
        for change in features2changes[feature_id]:
            if change['feature_text_id']:
                featuresid2text[feature_id] = change['feature_text_id']
                break

    if not featuresid2text.keys():
        return

    message = u"История изменения фичей за прошедшее время (окружение: %s):\n%s" % (
        settings.CONFIGURATION,
        u"\n\n".join(
            u"### %s\n%s" % (
                featuresid2text[feature_id] if feature_id in featuresid2text else 'id: %d' % feature_id,
                u"\n\n".join(
                    u"%d. %s\n%s\n%s\nИзменения:\n%s" % (
                        idx,
                        change['event_time'],
                        uid2login.get(change['operator_uid'], u"автор неизвестен"),
                        change['event_type'],
                        change['diff'] if change['diff'] else u"отсутствуют",
                    ) for idx, change in enumerate(features2changes[feature_id], 1)
                )
            )
            for feature_id in sorted(featuresid2text.keys())
        )
    )

    if settings.CONFIGURATION not in CONF_TO_CHAT_ID:
        print message
        print "-" * 40
    else:
        TelegramBot(BOT_CONFIG).send_reply(message, MessageContentTypes.text, CONF_TO_CHAT_ID[settings.CONFIGURATION])


def main():
    if datetime.today().weekday() >= 5:
        return

    features_history_reader.read_with_handler(PROPERTY_NAME, new_changes_handler, diff=True)


if __name__ == '__main__':
    try:
        set_logging(loglevel=logging.WARNING)
        logging.warn("start")

        main()

        juggler_queue_event(SERVICE_NAME, 'OK', '')
        logging.warn('success')
    except Exception as e:
        logging.exception('unexpected exception')
        juggler_queue_event(SERVICE_NAME, 'CRIT', 'unexpected exception: %s %s' % (type(e), e))

