#!/usr/bin/env python
# -*- coding: utf-8 -*-

""" METADATA

<crontab>
    time: */5 * * * *
    <switchman>
        lockname: upload_features_history_to_infra.py
        group: scripts-other
        delay: 3
    </switchman>
    package: scripts-switchman
</crontab>
<crontab>
    time: */5 * * * *
    <switchman>
        lockname: upload_features_history_to_infra.py
        group: scripts-test
        delay: 3
    </switchman>
    package: conf-test-scripts
</crontab>
<juggler>
    host:       direct.prod_javaperl
    name:       scripts.upload_features_history_to_infra.working
    raw_events: scripts.upload_features_history_to_infra.working
    ttl:        8m
    tag:        directadmin_TV
</juggler>

"""

"""
Отправляем в infra.yandex-team.ru историю изменения фичей
"""

import sys
import os.path
import logging
from datetime import datetime, timedelta
import subprocess

sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))
import settings
from yandex.juggler import juggler_queue_event
from direct.tools import set_logging
import direct.features_history_reader as features_history_reader


SERVICE_NAME = 'scripts.upload_features_history_to_infra.working'
PROPERTY_NAME = 'upload_features_history_to_infra.last_event_datetime'
INFRA_SERVICE = '1531' # service: Директ: фичи
CONF_TO_ENVIRONMENT = {
    'production': '2369', # environment: prod
    'test': '2396', # environment: test
    'devtest': '2397' # environment: devtest, for testing
}


def new_changes_handler(new_changes):
    uid2login = features_history_reader.get_uid2login(set(str(change['operator_uid']) for change in new_changes))
    featuresid2text = {}
    for change in new_changes:
        if change['feature_text_id']:
            featuresid2text[change['feature_id']] = change['feature_text_id']

    for change in new_changes:
        if change['feature_id'] not in featuresid2text:
            continue

        title = u'Изменение фичи %s' % featuresid2text[change['feature_id']]
        description = u'Автор изменения: %s\nОперация: %s\nreqid: %s\nИзменения:\n%s' % (
            uid2login.get(change['operator_uid'], u"неизвестен"),
            change['event_type'],
            change['reqid'],
            change['diff']
        )
        change_time = change['event_time'].strftime('%Y-%m-%d %H:%M')

        if not settings.CONFIGURATION or settings.CONFIGURATION not in CONF_TO_ENVIRONMENT:
            print u"%s\n%s\n%s" % (title, description, change_time)
            print u"-" * 40
            continue

        subprocess.check_output([
            '/usr/local/bin/create-infra-event',
            '-s', INFRA_SERVICE,
            '-e', CONF_TO_ENVIRONMENT[settings.CONFIGURATION],
            '-t', 'maintenance',
            '-sv', 'major',
            '--title', title,
            '--description', description,
            '--start-time', change_time,
            '--finish-time', change_time,
            '--token', '/etc/direct-tokens/oauth_infra_robot-direct-infra'
        ])


def main():
    features_history_reader.read_with_handler(PROPERTY_NAME, new_changes_handler, diff=True)


if __name__ == '__main__':
    try:
        set_logging(loglevel=logging.WARNING)
        logging.warn("start")

        main()

        juggler_queue_event(SERVICE_NAME, 'OK', '')
        logging.warn('success')
    except Exception as e:
        logging.exception('unexpected exception')
        juggler_queue_event(SERVICE_NAME, 'CRIT', 'unexpected exception: %s %s' % (type(e), e))

