# -*- encoding: utf-8 -*-

""" Конфигурация, читаемая при импорте из файла etc/settings.yaml
    Файл генерируется скриптом protected/maintenance/make_yaml_settings.pl
"""

import os
import sys
import stat
import yaml

ROOT = os.path.realpath(os.path.join(os.path.dirname(__file__), ".."))

SHARDS_NUM = None
LOG_ROOT = None
SETTINGS_YAML_FILENAME = None

def _load_config():
    settings_filename = None
    for filename in [os.path.join(ROOT, "etc", 'settings.yaml'), 'settings.yaml']:
        if os.path.isfile(filename) and os.stat(filename)[stat.ST_SIZE]:
            settings_filename = filename
            break

    if settings_filename is None:
        raise Exception("No suitable settings.yaml file found")

    cfg = yaml.load(open(settings_filename), Loader=yaml.CLoader)
    module = sys.modules[__name__]
    setattr(module, 'SETTINGS_YAML_FILENAME', settings_filename);
    for key, val in cfg.items():
        setattr(module, key, val)


def _set_yt_environ(cluster=None):
    # для авторизации указываем в переменной окружения, где лежит токен
    # важно, чтобы переменная устанавливалась раньше, чем происходит import yt.wrapper
    module = sys.modules[__name__]
    if cluster is None:
        cluster = os.environ.get('YT_DIRECT_CLUSTER', 'prod')
    conf = getattr(module, 'YT_CONF')[cluster]
    for key in ['token_path', 'proxy', 'prefix']:
        envname = 'YT_' + key.upper()
        if os.environ.get(envname, '') == '':
            os.environ[envname] = conf[key]


_load_config()
_set_yt_environ()
