# encoding: utf-8
"""
работа с juggler
"""

import json
import socket
import time
import urllib
import urllib2

JUGGLER_API_ADDRESS = 'http://localhost:31579/events'
HOSTNAME = socket.getfqdn()
TIMEOUT = 3
TRIES = 2
RETRY_DELAY = 7

def juggler_queue_event(service, status=None, description=None):
    """
    отправка события в juggler
    """

    headers = { 'content-type': 'application/json' }

    if status is None:
        status = 'OK'
    if description is None:
        description = status

    event = { 'host': HOSTNAME[:192],
              'service': service[:128],
              'status': status,
              'description': description[:1024]
            }
    message = { 'source': 'juggler_events',
                'events': [event]
              }

    data = json.dumps(message)
    req = urllib2.Request(JUGGLER_API_ADDRESS, data, headers)

    for retry in range(TRIES):
        try:
            urllib2.urlopen(req, timeout=TIMEOUT)
            break
        except Exception as err:
            if retry >= TRIES-1: raise
            time.sleep(RETRY_DELAY)
