# -*- encoding: utf-8 -*-
"""
Простой sftp клиент на основе paramiko
"""

from contextlib import contextmanager
import paramiko
import os, socket

from yandex.utils import save_pydoc, elogin

#__all__ = ['get_sftp']

@save_pydoc(contextmanager)
def get_sftp(hostname, username=None, timeout=None, check_hostkey=False):
    """
    Законнектиться на hostname под пользователем username
    Возвращает контекст SFTPClient
    """
    known_hosts_file = os.path.join(os.environ['HOME'], '.ssh', 'known_hosts')
    if check_hostkey:
        keys = paramiko.util.load_host_keys(known_hosts_file)
        hostkey = keys[hostname].values()[0]
    else:
        hostkey = None
    pkey = None
    for keyclass, filename in [(paramiko.RSAKey, 'id_rsa'), (paramiko.DSSKey, 'id_dsa')]:
        full_filename = os.path.join(os.environ['HOME'], '.ssh', filename)
        if os.path.exists(full_filename):
            pkey = keyclass.from_private_key_file(filename=full_filename)
            break
    if pkey == None:
        raise Exception('ssh keys not found')
    sock = socket.socket()
    if timeout != None:
        sock.settimeout(timeout)
    sock.connect((hostname, 22))
    transport = paramiko.Transport(sock)
    try:
        transport.window_size = 16777216
        transport.connect(username=username or elogin(), hostkey=hostkey, pkey=pkey)
        yield paramiko.SFTPClient.from_transport(transport)
    finally:
        transport.close()

