# -*- encoding: utf-8 -*-

import unittest
from unittest import TestResult

def tap_run(tests=None):
    unittest.main(testRunner=TAPTestRunner(tests=tests))

class _TAPTestResult(TestResult):
    def __init__(self, tests=None):
        TestResult.__init__(self)
        self.current_test = 0
        if tests:
            print "1..%d" % tests

    def getDescription(self, test):
        return test.shortDescription() or str(test)

    def startTest(self, test):
        TestResult.startTest(self, test)

    def addSuccess(self, test):
        TestResult.addSuccess(self, test)
        self.current_test += 1
        print "ok %d %s" % (self.current_test, self.getDescription(test))

    def addError(self, test, err):
        TestResult.addError(self, test, err)
        self.current_test += 1
        print "not ok %d %s" % (self.current_test, self.getDescription(test))
        for line in err[1].message.split("\n"):
            print "# %s" % line

    def addFailure(self, test, err):
        TestResult.addFailure(self, test, err)
        self.current_test += 1
        print "not ok %d %s: %s" % (self.current_test, self.getDescription(test), err[1].message.split("\n")[0])


class TAPTestRunner:
    def __init__(self, tests=None):
        self.tests = tests

    def _makeResult(self):
        return _TAPTestResult(tests=self.tests)

    def run(self, test):
        result = self._makeResult()
        test(result)
        return result
