#!/usr/bin/perl

#  $Id$

use warnings;
use strict;
use UNIVERSAL;
use Apache2::Const qw(OK);
use Apache2::RequestUtil;
use Carp;

use Yandex::Trace;
use Yandex::Log;

use Settings;
use DoCmd;
use MailService;
use EnvTools;
use HttpTools qw//;
use SentryTools qw//;
use LogTools qw//;

sub main {
    # запрещаем одному запросу генерить больше мегабайта error.log
    #use Yandex::PerlIO::via::Truncate;
    #Yandex::PerlIO::via::Truncate::init(\*STDERR, 1_000_000);

    # возможно, Trace начался в AuthAdwords, если нет - стартуем его тут
    my $trace = Yandex::Trace::current_trace() // Yandex::Trace->new(method => 'main', service => 'direct.perl.web');
    
    # в Apache2 метод Apache2::RequestUtil->request->status() не возвращает нам 500-х ошибок
    # даже если мы умираем, то внутри END{} этот метод возвращает 200
    # редиреты возвращает правильно, т.к. для них статус явно выставляется нами
    # поэтому для записи в лог хотя бы части ошибок, отлавливаем сами большую часть таких случаев
    our $force_http_status_code = 0;
    
    my $r = Apache2::RequestUtil->request;
    my $result;
    eval {
        HttpTools::apache_add_cleanup($Settings::APACHE_MAX_PROC_SIZE, $trace->trace_id());

        local $Carp::MaxArgLen = 4096;
        local $SIG{__DIE__} = SentryTools::prepare_die_handler();
    
        # reqid передается только для "видимости" в stacktrace'ах
        $result = do_direct_cmd($r, reqid => $trace->trace_id());
    };
    
    my $e = $@;
    if ($e) {
        if (UNIVERSAL::isa($e, 'Direct::HttpResponse')) {
            print "Content-Type: ".($e->{type}||'text/html')."\n\n";
            print $e->{body_sub} ? $e->{body_sub}->($trace->trace_id()) : $e->{body};
            undef $e;
        } else {
            my $connection_aborted = eval { $r->connection->aborted };
            # не пишем об ошибках закрытия соединения со стороны браузера ("Software caused connection abort")
            if ($connection_aborted) {
                # подходящего статуса в http нет, поэтому используем свой 2xx
                $r->status(299);
                $force_http_status_code = 299;
            } else {
                send_die_letters($e, SentryTools::get_last_stacktrace());

                # пишем в log
                LogTools::log_messages("500-error", "$e: ".SentryTools::get_last_stacktrace());

                # пишем в Sentry
                SentryTools::send_last_exception($e, skip => ['main'], skip_re => [qr|^ModPerl::|]);

                $force_http_status_code = 500;
            }
            
            $e = $e->{message} if ref($e) eq 'HASH';
            if (is_beta()) {
                print STDERR "$e ".SentryTools::get_last_stacktrace()."\n";
            }
        }
    }

    DoCmd::log_cmd_in_docmd($force_http_status_code);
    die "$e\n" if $e;
    
    return $result || OK;
}

main();
