#!/usr/bin/perl

use Direct::Modern;

use Test::More;
use Yandex::Test::UTF8Builder;
use ADVQ6;

my @test_data = (
    [ "слово -минус",    [ qw/плюс/ ],                      "слово -минус -плюс",
                                                            "слово -минус -плюс" ],
    [ "слово минус +на", [ qw/плюс на/ ],                   "слово минус +на -плюс -!на",
                                                            "слово минус +на -плюс" ],
    [ "слово минус +на", [ qw/плюс на !на/ ],               "слово минус +на -плюс -!на",
                                                            "слово минус +на -плюс" ],
    [ "слово минус +на", [ qw/[плюс] [на]/ ],               "слово минус +на -плюс -!на",
                                                            "слово минус +на -плюс" ],
    [ "слово минус +на", [ "белая вода", '"котик"' ],       "слово минус +на -(белая вода) -(\"котик\")",
                                                            "слово минус +на -(белая вода) -(\"котик\")" ],
    [ '"котик"',         [ "белая вода", '"котик"' ],       '"котик"',
                                                            '"котик"' ],
    [ 'пена морская',    [ "мыльная пена", '"котик"' ],     'пена морская -(мыльная пена) -("котик")',
                                                            'пена морская -(мыльная пена) -("котик")' ],
    [ 'пена морская',    [ "[мыльная пена]", '"котик"' ],   'пена морская -([мыльная пена]) -("котик")',
                                                            'пена морская -([мыльная пена]) -("котик")' ],
    [ 'цветы в горшках недорого', [ "цветы недорого" ],     'цветы в горшках недорого -(цветы недорого)',
                                                            'цветы в горшках недорого' ],
    [ 'цветы !в горшках недорого', [ "цветы +в горшках" ],  'цветы !в горшках недорого -(цветы +в горшках)',
                                                            'цветы !в горшках недорого' ],
    [ '!купить цветы +в горшках', [ "!купить +в горшках" ], '!купить цветы +в горшках -(!купить +в горшках)',
                                                            '!купить цветы +в горшках' ],
    [ 'купить цветы +в горшках', [ "купить в горшках" ],    'купить цветы +в горшках -(купить !в горшках)',
                                                            'купить цветы +в горшках' ],
    [ 'билеты [Москва Париж]', [ "[Москва] Париж" ],        'билеты [Москва Париж] -([Москва] Париж)',
                                                            'билеты [Москва Париж]' ],
);

for my $data (@test_data) {
    my ($phrase, $minus_phrases, $res_simple, $res_intersection) = @$data;

    is(ADVQ6::format_advq_query($phrase, minus_words => $minus_phrases), $res_simple);
    is(ADVQ6::format_advq_query($phrase, minus_words => $minus_phrases, remove_intersection => 1), $res_intersection);
}

done_testing;
