package TestData;

use warnings;
use strict;
use utf8;

use my_inc '../../';
use Settings;

use base qw/Exporter/;

our $TEST_SHARD = 2;
our $db = {
    ppc_properties => {
        original_db => PPCDICT,
        rows => [
            { name => "MAX_FULL_LB_EXPORT_CAMPAIGNS_IN_QUEUE", value => 10},
            { name => "FULL_LB_EXPORT_MAX_CHUNK_PER_ITERATION", value => 1},
            { name => "FULL_LB_EXPORT_LAST_PROCESSED_CID_SHARD_2", value => 0},
            { name => "ALLOW_FULL_LB_EXPORT_ROLLING_WORK", value => 1},
        ]
    },
    shard_inc_cid => {
        original_db => PPCDICT,
        rows => [
            {cid => 392908200, ClientID => 2729636 },
            {cid => 392908201, ClientID => 2729636 },
            {cid => 392908210, ClientID => 2729636 },
            {cid => 392908211, ClientID => 2729636 },
            {cid => 392908217, ClientID => 2729636 },
            {cid => 392908218, ClientID => 2729636 },
            {cid => 392908219, ClientID => 2729636 },
            {cid => 392908220, ClientID => 2729636 },
            {cid => 392908221, ClientID => 2729636 },
        ]
    },
    shard_client_id => {
        original_db => PPCDICT,
        rows => [
            { ClientID => 2729636, shard => $TEST_SHARD }
        ]
    },
    bs_export_candidates => {
        original_db => PPC(shard => 'all'),
        rows => {
            $TEST_SHARD => [ ],
        },
    },
    bs_export_specials => {
        original_db => PPC(shard => 'all'),
        rows => {
            $TEST_SHARD => [ ],
        },
    },
    bs_export_queue => {
        original_db => PPC(shard => 'all'),
        rows => {
            $TEST_SHARD => [ ],
        },
    },
    banner_images => {
        original_db => PPC(shard => 'all'),
        rows => {
            $TEST_SHARD => [
                {
                    bid => 876765407, # text_banner
                    image_id => 1,
                    image_hash => '3gwjOAnXfuzXl4MiT5Py3g',
                    BannerID => 0,
                    name => 'wiki.yandex.net.png',
                    statusModerate => 'Yes',
                    statusShow => 'Yes',
                    date_added => '2013-03-14 17:22:44'
                }, {
                    bid => 876765422,   # dynamic_banner
                    image_id => 2,
                    image_hash => 'CfopEbXs-HcKXRYKV8w4bg',
                    BannerID => 0,
                    name => 'панда3.jpg',
                    statusModerate => 'Yes',
                    statusShow => 'Yes',
                    date_added => '2014-10-07 16:34:14'
                },
            ],
        },
    },
    images => { original_db => PPC(shard => 'all') },
    banners_performance => { original_db => PPC(shard => 'all') },
    perf_creatives => { original_db => PPC(shard => 'all') },
    adgroups_dynamic             => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    main_domain_id          => 13536662,
                    pid                     => 686851142,
                }
            ]
        }
    },
    banners                      => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    BannerID                => 0,
                    bid                     => 876765302,
                    body                    => "И тут снизу постучали...",
                    cid                     => 392908210,
                    domain                  => "yandex.ru",
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 0,
                    href                    => "http://yandex.ru/",
                    LastChange              => "2015-04-10 19:24:48",
                    opts                    => "",
                    phoneflag               => "Yes",
                    pid                     => 686851102,
                    reverse_domain          => "ur.xednay",
                    sitelinks_set_id        => 166815692,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "Yes",
                    statusModerate          => "Yes",
                    statusPostModerate      => "Yes",
                    statusShow              => "Yes",
                    statusSitelinksModerate => "Yes",
                    title                   => "На дне",
                    type                    => "desktop",
                    vcard_id                => 21451497,
                },
                {
                    BannerID                => 0,
                    bid                     => 876765307,
                    body                    => "И тут снизу постучали...",
                    cid                     => 392908211,
                    domain                  => "yandex.ru",
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 0,
                    href                    => "http://yandex.ru/",
                    LastChange              => "2015-04-10 19:24:48",
                    opts                    => "",
                    phoneflag               => "Yes",
                    pid                     => 686851107,
                    reverse_domain          => "ur.xednay",
                    sitelinks_set_id        => 166815692,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "Yes",
                    statusModerate          => "Yes",
                    statusPostModerate      => "Yes",
                    statusShow              => "Yes",
                    statusSitelinksModerate => "Yes",
                    title                   => "На дне",
                    type                    => "desktop",
                    vcard_id                => 21451497,
                },
                {
                    BannerID                => 0,
                    bid                     => 876765397,
                    body                    => "И тут снизу постучали...",
                    cid                     => 392908217,
                    domain                  => "yandex.ru",
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 0,
                    href                    => "http://yandex.ru/",
                    LastChange              => "2015-04-10 19:24:48",
                    opts                    => "",
                    phoneflag               => "Yes",
                    pid                     => 686851132,
                    reverse_domain          => "ur.xednay",
                    sitelinks_set_id        => 166815692,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "Yes",
                    statusModerate          => "Yes",
                    statusPostModerate      => "Yes",
                    statusShow              => "Yes",
                    statusSitelinksModerate => "Yes",
                    title                   => "На дне",
                    type                    => "desktop",
                    vcard_id                => 21451497,
                },
                {
                    BannerID                => 0,
                    bid                     => 876765402,
                    body                    => "С нашими донными раками вы сольете любую игру!",
                    cid                     => 392908217,
                    domain                  => "yandex.ru",
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 0,
                    href                    => "http://yandex.ru/",
                    LastChange              => "2015-04-10 19:24:48",
                    opts                    => "",
                    phoneflag               => "New",
                    pid                     => 686851132,
                    reverse_domain          => "ur.xednay",
                    sitelinks_set_id        => undef,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "Yes",
                    statusModerate          => "Yes",
                    statusPostModerate      => "Yes",
                    statusShow              => "Yes",
                    statusSitelinksModerate => "New",
                    title                   => "Донные раки",
                    type                    => "desktop",
                    vcard_id                => undef,
                },
                {
                    BannerID                => 0,
                    bid                     => 876765407,
                    body                    => "API banner text",
                    cid                     => 392908217,
                    domain                  => "yandex.ru",
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 1,
                    href                    => "http://yandex.ru/",
                    LastChange              => "2015-04-10 19:24:48",
                    opts                    => "",
                    phoneflag               => "New",
                    pid                     => 686851137,
                    reverse_domain          => "ur.xednay",
                    sitelinks_set_id        => undef,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "Yes",
                    statusModerate          => "Yes",
                    statusPostModerate      => "Yes",
                    statusShow              => "Yes",
                    statusSitelinksModerate => "New",
                    title                   => "API banner title",
                    type                    => "desktop",
                    vcard_id                => undef,
                },
                {
                    banner_type             => 'dynamic',
                    BannerID                => 0,
                    bid                     => 876765412,
                    body                    => "продаем летающих слонов",
                    cid                     => 392908217,
                    domain                  => undef,
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 0,
                    href                    => undef,
                    LastChange              => "2015-04-10 19:25:41",
                    opts                    => "",
                    phoneflag               => "New",
                    pid                     => 686851142,
                    reverse_domain          => undef,
                    sitelinks_set_id        => undef,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "Yes",
                    statusModerate          => "Yes",
                    statusPostModerate      => "Yes",
                    statusShow              => "Yes",
                    statusSitelinksModerate => "New",
                    title                   => "«dynamic title»",
                    type                    => "desktop",
                    vcard_id                => undef,
                },
                {
                    banner_type             => 'dynamic',
                    BannerID                => 0,
                    bid                     => 876765417,
                    body                    => "продаем слонов со скидкой",
                    cid                     => 392908217,
                    domain                  => undef,
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 0,
                    href                    => undef,
                    LastChange              => "2015-04-10 19:25:41",
                    opts                    => "",
                    phoneflag               => "New",
                    pid                     => 686851142,
                    reverse_domain          => undef,
                    sitelinks_set_id        => undef,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "Yes",
                    statusModerate          => "Yes",
                    statusPostModerate      => "Yes",
                    statusShow              => "Yes",
                    statusSitelinksModerate => "New",
                    title                   => "«dynamic title»",
                    type                    => "desktop",
                    vcard_id                => undef,
                },
                {
                    banner_type             => 'dynamic',
                    BannerID                => 0,
                    bid                     => 876765422,
                    body                    => "распродажа слонов, со скидкой",
                    cid                     => 392908217,
                    domain                  => undef,
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 0,
                    href                    => undef,
                    LastChange              => "2015-04-10 19:25:41",
                    opts                    => "",
                    phoneflag               => "New",
                    pid                     => 686851142,
                    reverse_domain          => undef,
                    sitelinks_set_id        => undef,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "Yes",
                    statusModerate          => "Yes",
                    statusPostModerate      => "Yes",
                    statusShow              => "Yes",
                    statusSitelinksModerate => "New",
                    title                   => "«dynamic title»",
                    type                    => "desktop",
                    vcard_id                => undef,
                },
                {
                    banner_type             => 'dynamic',
                    BannerID                => 0,
                    bid                     => 876765427,
                    body                    => "слоны летающие: ттх, отзывы, купить",
                    cid                     => 392908217,
                    domain                  => undef,
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 0,
                    href                    => undef,
                    LastChange              => "2015-04-10 19:25:41",
                    opts                    => "",
                    phoneflag               => "New",
                    pid                     => 686851142,
                    reverse_domain          => undef,
                    sitelinks_set_id        => undef,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "Yes",
                    statusModerate          => "Yes",
                    statusPostModerate      => "Yes",
                    statusShow              => "Yes",
                    statusSitelinksModerate => "New",
                    title                   => "«dynamic title»",
                    type                    => "desktop",
                    vcard_id                => undef,
                },
                {
                    BannerID                => 0,
                    bid                     => 876765432,
                    body                    => "Безразмерные, тянучие, красивые, не вонючие",
                    cid                     => 392908218,
                    domain                  => "yandex.ru",
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 0,
                    href                    => "http://yandex.ru/",
                    LastChange              => "2015-04-10 19:24:48",
                    opts                    => "",
                    phoneflag               => "New",
                    pid                     => 686851147,
                    reverse_domain          => "ur.xednay",
                    sitelinks_set_id        => undef,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "Yes",
                    statusModerate          => "Yes",
                    statusPostModerate      => "Yes",
                    statusShow              => "Yes",
                    statusSitelinksModerate => "New",
                    title                   => "Разноцветные носки на все дни недели",
                    type                    => "desktop",
                    vcard_id                => undef,
                },
                {
                    BannerID                => 0,
                    bid                     => 876765437,
                    body                    => "На ходу. Продаю за ненадобностью",
                    cid                     => 392908219,
                    domain                  => "yandex.ru",
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 0,
                    href                    => "http://yandex.ru/",
                    LastChange              => "2015-04-10 19:24:48",
                    opts                    => "",
                    phoneflag               => "New",
                    pid                     => 686851152,
                    reverse_domain          => "ur.xednay",
                    sitelinks_set_id        => undef,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "No",
                    statusModerate          => "Yes",
                    statusPostModerate      => "No",
                    statusShow              => "No",
                    statusSitelinksModerate => "New",
                    title                   => "Почка левая",
                    type                    => "desktop",
                    vcard_id                => undef,
                },
                {
                    BannerID                => 0,
                    bid                     => 876765442,
                    body                    => "Скидка!! Поцарапали при перевозке.",
                    cid                     => 392908220,
                    domain                  => "yandex.ru",
                    domain_id               => undef,
                    flags                   => undef,
                    geoflag                 => 0,
                    href                    => "http://yandex.ru/",
                    LastChange              => "2015-04-10 19:24:48",
                    opts                    => "",
                    phoneflag               => "New",
                    pid                     => 686851157,
                    reverse_domain          => "ur.xednay",
                    sitelinks_set_id        => undef,
                    statusActive            => "No",
                    statusArch              => "No",
                    statusBsSynced          => "No",
                    statusModerate          => "No",
                    statusPostModerate      => "No",
                    statusShow              => "No",
                    statusSitelinksModerate => "New",
                    title                   => "Печень хорошего но мертвого спортсмена",
                    type                    => "desktop",
                    vcard_id                => undef,
                },
            ]
        }
    },
    bids                         => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    autobudgetPriority => 3,
                    cid                => 392908210,
                    id                 => 3529812802,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "хедкраб",
                    numword            => 1,
                    optimizeTry        => 0,
                    phrase             => "Хедкраб",
                    PhraseID           => 0,
                    pid                => 686851102,
                    place              => 3,
                    price              => 0.78,
                    price_context      => 0.00,
                    showsForecast      => 5762,
                    statusBsSynced     => "Yes",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908211,
                    id                 => 3529812807,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "хедкраб",
                    numword            => 1,
                    optimizeTry        => 0,
                    phrase             => "Хедкраб",
                    PhraseID           => 0,
                    pid                => 686851107,
                    place              => 3,
                    price              => 0.78,
                    price_context      => 0.00,
                    showsForecast      => 5762,
                    statusBsSynced     => "Yes",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908217,
                    id                 => 3529812852,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "хедкраб",
                    numword            => 1,
                    optimizeTry        => 0,
                    phrase             => "Хедкраб",
                    PhraseID           => 0,
                    pid                => 686851132,
                    place              => 3,
                    price              => 0.78,
                    price_context      => 0.00,
                    showsForecast      => 5762,
                    statusBsSynced     => "Yes",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908217,
                    id                 => 3529812857,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "донный краб",
                    numword            => 2,
                    optimizeTry        => 0,
                    phrase             => "Донный краб",
                    PhraseID           => 0,
                    pid                => 686851132,
                    place              => 3,
                    price              => 0.55,
                    price_context      => 0.00,
                    showsForecast      => 9,
                    statusBsSynced     => "Yes",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908217,
                    id                 => 3529812862,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "краб морской",
                    numword            => 2,
                    optimizeTry        => 0,
                    phrase             => "Краб морской",
                    PhraseID           => 0,
                    pid                => 686851132,
                    place              => 3,
                    price              => 0.33,
                    price_context      => 0.00,
                    showsForecast      => 797,
                    statusBsSynced     => "Yes",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908217,
                    id                 => 3529812867,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "краб",
                    numword            => 1,
                    optimizeTry        => 0,
                    phrase             => "Краб -морской -донный",
                    PhraseID           => 0,
                    pid                => 686851132,
                    place              => 3,
                    price              => 0.11,
                    price_context      => 0.00,
                    showsForecast      => 127317,
                    statusBsSynced     => "Yes",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908217,
                    id                 => 3529812872,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "хедкраб",
                    numword            => 1,
                    optimizeTry        => 0,
                    phrase             => "Хедкраб",
                    PhraseID           => 0,
                    pid                => 686851137,
                    place              => 3,
                    price              => 0.78,
                    price_context      => 0.00,
                    showsForecast      => 1153,
                    statusBsSynced     => "Yes",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908217,
                    id                 => 3529812877,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "донный краб",
                    numword            => 2,
                    optimizeTry        => 0,
                    phrase             => "Донный краб",
                    PhraseID           => 0,
                    pid                => 686851137,
                    place              => 3,
                    price              => 0.55,
                    price_context      => 0.00,
                    showsForecast      => 6,
                    statusBsSynced     => "Yes",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908217,
                    id                 => 3529812882,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "краб морской",
                    numword            => 2,
                    optimizeTry        => 0,
                    phrase             => "Краб морской",
                    PhraseID           => 0,
                    pid                => 686851137,
                    place              => 3,
                    price              => 0.33,
                    price_context      => 0.00,
                    showsForecast      => 214,
                    statusBsSynced     => "Yes",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908217,
                    id                 => 3529812887,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "краб",
                    numword            => 1,
                    optimizeTry        => 0,
                    phrase             => "Краб -морской -донный",
                    PhraseID           => 0,
                    pid                => 686851137,
                    place              => 3,
                    price              => 0.11,
                    price_context      => 0.00,
                    showsForecast      => 40715,
                    statusBsSynced     => "Yes",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908218,
                    id                 => 35298128892,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "босоног",
                    numword            => 1,
                    optimizeTry        => 0,
                    phrase             => "босоног",
                    PhraseID           => 0,
                    pid                => 686851147,
                    place              => 3,
                    price              => 0.11,
                    price_context      => 0.00,
                    showsForecast      => 40715,
                    statusBsSynced     => "No",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908219,
                    id                 => 35298128897,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "хороший орган",
                    numword            => 1,
                    optimizeTry        => 0,
                    phrase             => "хорошие органы",
                    PhraseID           => 0,
                    pid                => 686851152,
                    place              => 3,
                    price              => 0.11,
                    price_context      => 0.00,
                    showsForecast      => 40715,
                    statusBsSynced     => "No",
                    statusModerate     => "Yes",
                    warn               => "Yes",
                },
                {
                    autobudgetPriority => 3,
                    cid                => 392908220,
                    id                 => 35298128902,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:24:18",
                    norm_phrase        => "куплю орган",
                    numword            => 1,
                    optimizeTry        => 0,
                    phrase             => "куплю орган -дешево",
                    PhraseID           => 0,
                    pid                => 686851157,
                    place              => 3,
                    price              => 0.11,
                    price_context      => 0.00,
                    showsForecast      => 40715,
                    statusBsSynced     => "No",
                    statusModerate     => "No",
                    warn               => "Yes",
                }
            ]
        }
    },
    bids_base => {
        original_db => PPC(shard => 'all'),
        rows => {
        },
    },
    bids_dynamic                 => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    autobudgetPriority => 5,
                    dyn_cond_id        => 32,
                    dyn_id             => 37,
                    opts               => "",
                    pid                => 686851142,
                    price              => 0.42,
                    price_context      => 1.14,
                    statusBsSynced     => "Yes"
                },
                {
                    autobudgetPriority => 5,
                    dyn_cond_id        => 37,
                    dyn_id             => 42,
                    opts               => "",
                    pid                => 686851142,
                    price              => 1.70,
                    price_context      => 1.60,
                    statusBsSynced     => "Yes"
                }
            ]
        }
    },
    bids_performance => {
        original_db => PPC(shard => 'all'),
        rows => {
        },
    },
    bids_retargeting             => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    autobudgetPriority => 3,
                    bid                => 876765397,
                    is_suspended       => 0,
                    modtime            => "2015-04-10 19:21:40",
                    pid                => 686851132,
                    price_context      => 1.23,
                    ret_cond_id        => 234667,
                    ret_id             => 1990992,
                    statusBsSynced     => "Yes"
                }
            ]
        }
    },
    campaigns                    => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    AgencyID                 => 0,
                    AgencyUID                => undef,
                    archived                 => "No",
                    autobudget               => "No",
                    autobudget_date          => "0000-00-00",
                    autobudgetForecast       => undef,
                    autobudgetForecastDate   => undef,
                    autoOptimization         => "Yes",
                    balance_tid              => 1,
                    cid                      => 392908200,
                    clicks                   => undef,
                    ContextLimit             => 30,
                    ContextPriceCoef         => 50,
                    copiedFrom               => 0,
                    currency                 => "YND_FIXED",
                    currencyConverted        => "No",
                    day_budget               => 0.00,
                    day_budget_show_mode     => "default",
                    disabledIps              => "11.22.33.44",
                    DontShow                 => "qwerty.ru",
                    dontShowCatalog          => "No",
                    platform                 => 'both',
                    finish_time              => "0000-00-00",
                    geo                      => undef,
                    LastChange               => "2015-04-10 19:21:32",
                    lastShowTime             => "0000-00-00 00:00:00",
                    ManagerUID               => undef,
                    name                     => "Синхронизированный кошелек",
                    OrderID                  => 0,
                    paid_by_certificate      => "No",
                    ProductID                => 1475,
                    rf                       => 3,
                    rfReset                  => 0,
                    shows                    => undef,
                    start_time               => "2013-03-05",
                    statusActive             => "No",
                    statusAutobudgetForecast => "New",
                    statusBsArchived         => "No",
                    statusBsSynced           => "Yes",
                    statusEmpty              => "No",
                    statusMail               => 0,
                    statusModerate           => "Yes",
                    statusNoPay              => "No",
                    statusOpenStat           => "No",
                    statusShow               => "Yes",
                    sum                      => 18.000000,
                    sum_last                 => 18.000000,
                    sum_spent                => 0.000000,
                    sum_spent_units          => 0,
                    sum_to_pay               => 0.000000,
                    sum_units                => 18,
                    timeTarget               => "1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8JKLMNOPQ9",
                    timezone_id              => 130,
                    type                     => "wallet",
                    uid                      => 205058976,
                    wallet_cid               => 0
                },
                {
                    AgencyID                 => 0,
                        AgencyUID                => undef,
                        archived                 => "No",
                        autobudget               => "No",
                        autobudget_date          => "0000-00-00",
                        autobudgetForecast       => undef,
                        autobudgetForecastDate   => undef,
                        autoOptimization         => "Yes",
                        balance_tid              => 1,
                        cid                      => 392908201,
                        clicks                   => undef,
                        ContextLimit             => 30,
                        ContextPriceCoef         => 50,
                        copiedFrom               => 0,
                        currency                 => "YND_FIXED",
                        currencyConverted        => "No",
                        day_budget               => 0.00,
                        day_budget_show_mode     => "default",
                        disabledIps              => "11.22.33.44",
                        DontShow                 => "qwerty.ru",
                        dontShowCatalog          => "No",
                        platform                 => 'both',
                        finish_time              => "0000-00-00",
                        geo                      => undef,
                        LastChange               => "2015-04-10 19:21:32",
                        lastShowTime             => "0000-00-00 00:00:00",
                        ManagerUID               => undef,
                        name                     => "НЕ синхронизированный кошелек",
                        OrderID                  => 0,
                        paid_by_certificate      => "No",
                        ProductID                => 1475,
                        rf                       => 3,
                        rfReset                  => 0,
                        shows                    => undef,
                        start_time               => "2013-03-05",
                        statusActive             => "No",
                        statusAutobudgetForecast => "New",
                        statusBsArchived         => "No",
                        statusBsSynced           => "No",
                        statusEmpty              => "No",
                        statusMail               => 0,
                        statusModerate           => "Yes",
                        statusNoPay              => "No",
                        statusOpenStat           => "No",
                        statusShow               => "Yes",
                        sum                      => 18.000000,
                        sum_last                 => 18.000000,
                        sum_spent                => 0.000000,
                        sum_spent_units          => 0,
                        sum_to_pay               => 0.000000,
                        sum_units                => 18,
                        timeTarget               => "1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8JKLMNOPQ9",
                        timezone_id              => 130,
                        type                     => "wallet",
                        uid                      => 205058976,
                        wallet_cid               => 0
                },
                {
                    AgencyID                 => 0,
                    AgencyUID                => undef,
                    archived                 => "No",
                    autobudget               => "No",
                    autobudget_date          => "0000-00-00",
                    autobudgetForecast       => undef,
                    autobudgetForecastDate   => undef,
                    autoOptimization         => "Yes",
                    balance_tid              => 1,
                    cid                      => 392908210,
                    clicks                   => undef,
                    ContextLimit             => 30,
                    ContextPriceCoef         => 50,
                    copiedFrom               => 0,
                    currency                 => "YND_FIXED",
                    currencyConverted        => "No",
                    day_budget               => 0.00,
                    day_budget_show_mode     => "default",
                    disabledIps              => "11.22.33.44",
                    DontShow                 => "qwerty.ru",
                    dontShowCatalog          => "No",
                    platform                 => 'both',
                    finish_time              => "0000-00-00",
                    geo                      => undef,
                    LastChange               => "2015-04-10 19:21:32",
                    lastShowTime             => "0000-00-00 00:00:00",
                    ManagerUID               => undef,
                    name                     => "Тестовая кампания API #64",
                    OrderID                  => 0,
                    paid_by_certificate      => "No",
                    ProductID                => 1475,
                    rf                       => 3,
                    rfReset                  => 0,
                    shows                    => undef,
                    start_time               => "2013-03-05",
                    statusActive             => "No",
                    statusAutobudgetForecast => "New",
                    statusBsArchived         => "No",
                    statusBsSynced           => "No",
                    statusEmpty              => "No",
                    statusMail               => 0,
                    statusModerate           => "Yes",
                    statusNoPay              => "No",
                    statusOpenStat           => "No",
                    statusShow               => "Yes",
                    sum                      => 18.000000,
                    sum_last                 => 18.000000,
                    sum_spent                => 0.000000,
                    sum_spent_units          => 0,
                    sum_to_pay               => 0.000000,
                    sum_units                => 18,
                    timeTarget               => "1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8JKLMNOPQ9",
                    timezone_id              => 130,
                    type                     => "text",
                    uid                      => 205058976,
                    wallet_cid               => 392908200
                },
                {
                    AgencyID                 => 0,
                    AgencyUID                => undef,
                    archived                 => "No",
                    autobudget               => "No",
                    autobudget_date          => "0000-00-00",
                    autobudgetForecast       => undef,
                    autobudgetForecastDate   => undef,
                    autoOptimization         => "Yes",
                    balance_tid              => 1,
                    cid                      => 392908211,
                    clicks                   => undef,
                    ContextLimit             => 30,
                    ContextPriceCoef         => 50,
                    copiedFrom               => 0,
                    currency                 => "YND_FIXED",
                    currencyConverted        => "No",
                    day_budget               => 0.00,
                    day_budget_show_mode     => "default",
                    disabledIps              => "11.22.33.44",
                    DontShow                 => "qwerty.ru",
                    dontShowCatalog          => "No",
                    platform                 => 'both',
                    finish_time              => "0000-00-00",
                    geo                      => undef,
                    LastChange               => "2015-04-10 19:21:32",
                    lastShowTime             => "0000-00-00 00:00:00",
                    ManagerUID               => undef,
                    name                     => "Тестовая кампания API #64",
                    OrderID                  => 0,
                    paid_by_certificate      => "No",
                    ProductID                => 1475,
                    rf                       => 3,
                    rfReset                  => 0,
                    shows                    => undef,
                    start_time               => "2013-03-05",
                    statusActive             => "No",
                    statusAutobudgetForecast => "New",
                    statusBsArchived         => "No",
                    statusBsSynced           => "No",
                    statusEmpty              => "No",
                    statusMail               => 0,
                    statusModerate           => "Yes",
                    statusNoPay              => "No",
                    statusOpenStat           => "No",
                    statusShow               => "Yes",
                    sum                      => 18.000000,
                    sum_last                 => 18.000000,
                    sum_spent                => 0.000000,
                    sum_spent_units          => 0,
                    sum_to_pay               => 0.000000,
                    sum_units                => 18,
                    timeTarget               => "1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8JKLMNOPQ9",
                    timezone_id              => 130,
                    type                     => "text",
                    uid                      => 205058976,
                    wallet_cid               => 392908201
                },
                {
                    AgencyID                 => 0,
                    AgencyUID                => undef,
                    archived                 => "No",
                    autobudget               => "No",
                    autobudget_date          => "0000-00-00",
                    autobudgetForecast       => undef,
                    autobudgetForecastDate   => undef,
                    autoOptimization         => "Yes",
                    balance_tid              => 1,
                    cid                      => 392908217,
                    clicks                   => undef,
                    ContextLimit             => 30,
                    ContextPriceCoef         => 50,
                    copiedFrom               => 0,
                    currency                 => "YND_FIXED",
                    currencyConverted        => "No",
                    day_budget               => 0.00,
                    day_budget_show_mode     => "default",
                    disabledIps              => "11.22.33.44",
                    DontShow                 => "qwerty.ru",
                    dontShowCatalog          => "No",
                    platform                 => 'both',
                    finish_time              => "0000-00-00",
                    geo                      => undef,
                    LastChange               => "2015-04-10 19:21:32",
                    lastShowTime             => "0000-00-00 00:00:00",
                    ManagerUID               => undef,
                    name                     => "Тестовая кампания API #64",
                    OrderID                  => 0,
                    paid_by_certificate      => "No",
                    ProductID                => 1475,
                    rf                       => 3,
                    rfReset                  => 0,
                    shows                    => undef,
                    start_time               => "2013-03-05",
                    statusActive             => "No",
                    statusAutobudgetForecast => "New",
                    statusBsArchived         => "No",
                    statusBsSynced           => "Yes",
                    statusEmpty              => "No",
                    statusMail               => 0,
                    statusModerate           => "Yes",
                    statusNoPay              => "No",
                    statusOpenStat           => "No",
                    statusShow               => "Yes",
                    sum                      => 18.000000,
                    sum_last                 => 18.000000,
                    sum_spent                => 0.000000,
                    sum_spent_units          => 0,
                    sum_to_pay               => 0.000000,
                    sum_units                => 18,
                    timeTarget               => "1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8JKLMNOPQ9",
                    timezone_id              => 130,
                    type                     => "text",
                    uid                      => 205058976,
                    wallet_cid               => 0
                },
                {
                    AgencyID                 => 0,
                    AgencyUID                => undef,
                    archived                 => "No",
                    autobudget               => "No",
                    autobudget_date          => "0000-00-00",
                    autobudgetForecast       => undef,
                    autobudgetForecastDate   => undef,
                    autoOptimization         => "Yes",
                    balance_tid              => 1,
                    cid                      => 392908218,
                    clicks                   => undef,
                    ContextLimit             => 30,
                    ContextPriceCoef         => 50,
                    copiedFrom               => 0,
                    currency                 => "YND_FIXED",
                    currencyConverted        => "No",
                    day_budget               => 0.00,
                    day_budget_show_mode     => "default",
                    disabledIps              => "11.22.33.44",
                    DontShow                 => "qwerty.ru",
                    dontShowCatalog          => "No",
                    platform                 => 'both',
                    finish_time              => "0000-00-00",
                    geo                      => undef,
                    LastChange               => "2015-04-10 19:21:32",
                    lastShowTime             => "0000-00-00 00:00:00",
                    ManagerUID               => undef,
                    name                     => "Тестовая кампания API #64",
                    OrderID                  => 0,
                    paid_by_certificate      => "No",
                    ProductID                => 1475,
                    rf                       => 3,
                    rfReset                  => 0,
                    shows                    => undef,
                    start_time               => "2013-03-05",
                    statusActive             => "No",
                    statusAutobudgetForecast => "New",
                    statusBsArchived         => "No",
                    statusBsSynced           => "No",
                    statusEmpty              => "No",
                    statusMail               => 0,
                    statusModerate           => "Yes",
                    statusNoPay              => "No",
                    statusOpenStat           => "No",
                    statusShow               => "Yes",
                    sum                      => 18.000000,
                    sum_last                 => 18.000000,
                    sum_spent                => 0.000000,
                    sum_spent_units          => 0,
                    sum_to_pay               => 0.000000,
                    sum_units                => 18,
                    timeTarget               => "1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8JKLMNOPQ9",
                    timezone_id              => 130,
                    type                     => "text",
                    uid                      => 205058976,
                    wallet_cid               => 0
                },
                {
                    AgencyID                 => 0,
                    AgencyUID                => undef,
                    archived                 => "No",
                    autobudget               => "No",
                    autobudget_date          => "0000-00-00",
                    autobudgetForecast       => undef,
                    autobudgetForecastDate   => undef,
                    autoOptimization         => "Yes",
                    balance_tid              => 1,
                    cid                      => 392908219,
                    clicks                   => undef,
                    ContextLimit             => 30,
                    ContextPriceCoef         => 50,
                    copiedFrom               => 0,
                    currency                 => "YND_FIXED",
                    currencyConverted        => "No",
                    day_budget               => 0.00,
                    day_budget_show_mode     => "default",
                    disabledIps              => "11.22.33.44",
                    DontShow                 => "qwerty.ru",
                    dontShowCatalog          => "No",
                    platform                 => 'both',
                    finish_time              => "0000-00-00",
                    geo                      => undef,
                    LastChange               => "2015-04-10 19:21:32",
                    lastShowTime             => "0000-00-00 00:00:00",
                    ManagerUID               => undef,
                    name                     => "Тестовая кампания API #64",
                    OrderID                  => 0,
                    paid_by_certificate      => "No",
                    ProductID                => 1475,
                    rf                       => 3,
                    rfReset                  => 0,
                    shows                    => undef,
                    start_time               => "2013-03-05",
                    statusActive             => "No",
                    statusAutobudgetForecast => "New",
                    statusBsArchived         => "No",
                    statusBsSynced           => "No",
                    statusEmpty              => "No",
                    statusMail               => 0,
                    statusModerate           => "Yes",
                    statusNoPay              => "No",
                    statusOpenStat           => "No",
                    statusShow               => "Yes",
                    sum                      => 18.000000,
                    sum_last                 => 18.000000,
                    sum_spent                => 0.000000,
                    sum_spent_units          => 0,
                    sum_to_pay               => 0.000000,
                    sum_units                => 18,
                    timeTarget               => "1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8JKLMNOPQ9",
                    timezone_id              => 130,
                    type                     => "text",
                    uid                      => 205058976,
                    wallet_cid               => 0
                },
                {
                    AgencyID                 => 0,
                    AgencyUID                => undef,
                    archived                 => "No",
                    autobudget               => "No",
                    autobudget_date          => "0000-00-00",
                    autobudgetForecast       => undef,
                    autobudgetForecastDate   => undef,
                    autoOptimization         => "Yes",
                    balance_tid              => 1,
                    cid                      => 392908220,
                    clicks                   => undef,
                    ContextLimit             => 30,
                    ContextPriceCoef         => 50,
                    copiedFrom               => 0,
                    currency                 => "YND_FIXED",
                    currencyConverted        => "No",
                    day_budget               => 0.00,
                    day_budget_show_mode     => "default",
                    disabledIps              => "11.22.33.44",
                    DontShow                 => "qwerty.ru",
                    dontShowCatalog          => "No",
                    platform                 => 'both',
                    finish_time              => "0000-00-00",
                    geo                      => undef,
                    LastChange               => "2015-04-10 19:21:32",
                    lastShowTime             => "0000-00-00 00:00:00",
                    ManagerUID               => undef,
                    name                     => "Тестовая кампания API #64",
                    OrderID                  => 0,
                    paid_by_certificate      => "No",
                    ProductID                => 1475,
                    rf                       => 3,
                    rfReset                  => 0,
                    shows                    => undef,
                    start_time               => "2013-03-05",
                    statusActive             => "No",
                    statusAutobudgetForecast => "New",
                    statusBsArchived         => "No",
                    statusBsSynced           => "No",
                    statusEmpty              => "No",
                    statusMail               => 0,
                    statusModerate           => "Yes",
                    statusNoPay              => "No",
                    statusOpenStat           => "No",
                    statusShow               => "Yes",
                    sum                      => 18.000000,
                    sum_last                 => 18.000000,
                    sum_spent                => 0.000000,
                    sum_spent_units          => 0,
                    sum_to_pay               => 0.000000,
                    sum_units                => 18,
                    timeTarget               => "1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8JKLMNOPQ9",
                    timezone_id              => 130,
                    type                     => "text",
                    uid                      => 205058976,
                    wallet_cid               => 0
                }, {
                    cid => 392908221,
                    ClientID => 2729636,
                    uid => 205058976,
                    ManagerUID => 187146096,
                    AgencyUID => undef ,
                    name => "Новая",
                    LastChange => "2016-01-21 13:55:41",
                    start_time => "2008-07-01",
                    OrderID => 367310,
                    AgencyID => 0,
                    currency => "YND_FIXED",
                    sum_to_pay => "210.000000",
                    sum => "700.000000",
                    sum_spent => "700.000000",
                    sum_last => "700.000000",
                    sum_spent_units => 28000,
                    sum_units => 28000,
                    wallet_cid => 0,
                    statusModerate => "No",
                    statusShow => "Yes",
                    statusActive => "No",
                    shows => 28000,
                    clicks => 137,
                    statusEmpty => "No",
                    statusMail => 2,
                    archived => "No",
                    balance_tid => 8175794472050,
                    autobudget => "No",
                    platform => undef ,
                    strategy_name => undef ,
                    strategy_data => undef ,
                    autobudget_date => "2008-08-15",
                    statusBsSynced => "Yes",
                    statusNoPay => "No",
                    geo => 225,
                    DontShow => undef ,
                    autoOptimization => "No",
                    dontShowCatalog => "No",
                    autobudgetForecastDate => "2008-07-21 21:51:41",
                    autobudgetForecast => 0,
                    timeTarget => undef ,
                    timezone_id => 0,
                    lastShowTime => "2008-07-22 15:29:09",
                    statusBsArchived => "No",
                    statusOpenStat => "No",
                    disabledIps => undef ,
                    type => "mcb",
                    ProductID => 2584,
                    rf => 3,
                    rfReset => 28,
                    ContextLimit => 255,
                    ContextPriceCoef => 100,
                    finish_time => "0000-00-00",
                    day_budget => "0.00",
                    day_budget_show_mode => "default",
                    paid_by_certificate => "No",
                    currencyConverted => "No",
                    copiedFrom => 0,
                    opts => "",
                    disabled_ssp => undef,
                },
            ]
        }
    },
    camp_options                 => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    auto_optimize_request          => "No",
                    banners_per_page               => 0,
                    broad_match_flag               => "Yes",
                    broad_match_limit              => -1,
                    camp_description               => undef,
                    cid                            => 392908217,
                    competitors_domains            => undef,
                    contactinfo                    => "",
                    create_time                    => "2015-04-10 19:21:31",
                    day_budget_daily_change_count  => 0,
                    day_budget_notification_status => "Ready",
                    day_budget_stop_time           => "0000-00-00 00:00:00",
                    device_targeting               => "",
                    email                          => "ppalex\@yandex-team.ru",
                    email_notifications            => "paused_by_day_budget",
                    enabled_sms                    => "No",
                    fairAuction                    => "Yes",
                    FIO                            => "Иванов Иван Иванович",
                    is_related_keywords_enabled    => 1,
                    lastnews                       => 0,
                    last_pay_time                  => "2015-04-10 19:24:48",
                    manual_autobudget_sum          => undef,
                    mediaplan_status               => "None",
                    minus_words                    => "",
                    money_warning_value            => 1,
                    offlineStatNotice              => "No",
                    sendAccNews                    => "Yes",
                    sendNews                       => "Yes",
                    sendWarn                       => "Yes",
                    sms_flags                      => "notify_order_money_in_sms",
                    sms_time                       => "12:00:15:00",
                    status_click_track             => 0,
                    statusContextStop              => "Yes",
                    statusMetricaControl           => "No",
                    statusPostModerate             => "Accepted",
                    stopTime                       => "0000-00-00 00:00:00",
                    strategy                       => "",
                    valid                          => 2,
                    warnPlaceInterval              => 15
                }
            ]
        }
    },
    domains                      => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    domain         => "ppalex.com",
                    domain_id      => 13536662,
                    reverse_domain => "moc.xelapp"
                }
            ]
        }
    },
    dynamic_conditions           => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    pid            => 686851142,
                    condition_hash => 9243564304133471762,
                    condition_json => "[{\"type\":\"any\"}]",
                    dyn_cond_id    => 32
                },
                {
                    pid            => 686851142,
                    condition_hash => 11175392044800946928,
                    condition_json => "[{\"kind\":\"not_exact\",\"type\":\"URL\",\"value\":\"archive\"},{\"kind\":\"not_exact\",\"type\":\"domain\",\"value\":\"promo\"},{\"kind\":\"match\",\"type\":\"content\",\"value\":\"в наличии\"},{\"kind\":\"not_match\",\"type\":\"title\",\"value\":\"форум\"}]",
                    dyn_cond_id    => 37
                }
            ]
        }
    },
    phrases                      => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    adgroup_type         => "base",
                    bid                  => 876765302,
                    cid                  => 392908210,
                    forecastDate         => "2015-04-10 19:22:24",
                    geo                  => "225,-52,1091",
                    group_name           => "обычная группа",
                    LastChange           => "2015-04-10 19:24:18",
                    mw_id                => 3409992,
                    pid                  => 686851102,
                    statusAutobudgetShow => "Yes",
                    statusBsSynced       => "No",
                    statusModerate       => "Yes",
                    statusPostModerate   => "Yes",
                    statusShowsForecast  => "Processed"
                },
                {
                    adgroup_type         => "base",
                    bid                  => 876765307,
                    cid                  => 392908211,
                    forecastDate         => "2015-04-10 19:22:24",
                    geo                  => "225,-52,1091",
                    group_name           => "обычная группа",
                    LastChange           => "2015-04-10 19:24:18",
                    mw_id                => 3409992,
                    pid                  => 686851107,
                    statusAutobudgetShow => "Yes",
                    statusBsSynced       => "No",
                    statusModerate       => "Yes",
                    statusPostModerate   => "Yes",
                    statusShowsForecast  => "Processed"
                },
                {
                    adgroup_type         => "base",
                    bid                  => 876765397,
                    cid                  => 392908217,
                    forecastDate         => "2015-04-10 19:22:24",
                    geo                  => "225,-52,1091",
                    group_name           => "Ракообразные",
                    LastChange           => "2015-04-10 19:24:18",
                    mw_id                => 3409992,
                    pid                  => 686851132,
                    statusAutobudgetShow => "Yes",
                    statusBsSynced       => "Yes",
                    statusModerate       => "Yes",
                    statusPostModerate   => "Yes",
                    statusShowsForecast  => "Processed"
                },
                {
                    adgroup_type         => "base",
                    bid                  => 876765407,
                    cid                  => 392908217,
                    forecastDate         => "2015-04-10 19:22:24",
                    geo                  => "2,213",
                    group_name           => undef,
                    LastChange           => "2015-04-10 19:24:18",
                    mw_id                => 3409992,
                    pid                  => 686851137,
                    statusAutobudgetShow => "Yes",
                    statusBsSynced       => "Yes",
                    statusModerate       => "Yes",
                    statusPostModerate   => "Yes",
                    statusShowsForecast  => "Processed"
                },
                {
                    adgroup_type         => "dynamic",
                    bid                  => 876765412,
                    cid                  => 392908217,
                    forecastDate         => "0000-00-00 00:00:00",
                    geo                  => 0,
                    group_name           => "test dynamic adgroup #203",
                    LastChange           => "2015-04-10 19:25:41",
                    mw_id                => undef,
                    pid                  => 686851142,
                    statusAutobudgetShow => "Yes",
                    statusBsSynced       => "Yes",
                    statusModerate       => "Yes",
                    statusPostModerate   => "Yes",
                    statusShowsForecast  => "New"
                },
                {
                    adgroup_type         => "base",
                    bid                  => 876765432,
                    cid                  => 392908218,
                    forecastDate         => "2015-04-10 19:22:24",
                    geo                  => "225,-52,1091",
                    group_name           => "обычная группа",
                    LastChange           => "2015-04-10 19:24:18",
                    mw_id                => 3409992,
                    pid                  => 686851147,
                    statusAutobudgetShow => "Yes",
                    statusBsSynced       => "No",
                    statusModerate       => "Yes",
                    statusPostModerate   => "Yes",
                    statusShowsForecast  => "Processed"
                },
                {
                    adgroup_type         => "base",
                    bid                  => 876765437,
                    cid                  => 392908219,
                    forecastDate         => "2015-04-10 19:22:24",
                    geo                  => "225,-52,1091",
                    group_name           => "обычная группа",
                    LastChange           => "2015-04-10 19:24:18",
                    mw_id                => 3409992,
                    pid                  => 686851152,
                    statusAutobudgetShow => "Yes",
                    statusBsSynced       => "No",
                    statusModerate       => "Yes",
                    statusPostModerate   => "No",
                    statusShowsForecast  => "Processed"
                },
                {
                    adgroup_type         => "base",
                    bid                  => 876765442,
                    cid                  => 392908220,
                    forecastDate         => "2015-04-10 19:22:24",
                    geo                  => "225,-52,1091",
                    group_name           => "обычная группа",
                    LastChange           => "2015-04-10 19:24:18",
                    mw_id                => 3409992,
                    pid                  => 686851157,
                    statusAutobudgetShow => "Yes",
                    statusBsSynced       => "No",
                    statusModerate       => "No",
                    statusPostModerate   => "No",
                    statusShowsForecast  => "Processed"
                },
            ]
        }
    },
    users                        => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    allowed_ips      => "",
                    captcha_freq     => 0,
                    ClientID         => 2729636,
                    createtime       => 1364201953,
                    description      => undef,
                    email            => "ppalex\@yandex-team.ru",
                    FIO              => "Ed Золотухина",
                    hidden           => "No",
                    lang             => "ru",
                    LastChange       => "2015-04-10 19:08:04",
                    login            => "ppalex-client2",
                    not_resident     => "No",
                    phone            => '+712345678',
                    sendAccNews      => "No",
                    sendNews         => "Yes",
                    sendWarn         => "Yes",
                    showOnYandexOnly => "No",
                    statusArch       => "No",
                    statusBlocked    => "No",
                    statusYandexAdv  => "No",
                    uid              => 205058976,
                    valid            => 2
                }
            ]
        }
    },
    users_options                => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    agency_email_to_chief   => "No",
                    geo_id                  => 0,
                    manager_office_id       => undef,
                    manager_use_crm         => "No",
                    options                 => "---\ncan_have_device_targeting: 0\n",
                    opts                    => "",
                    passport_karma          => 0,
                    sendAgencyDirectLetters => "No",
                    sendAgencyMcbLetters    => "No",
                    sendClientLetters       => "Yes",
                    sendClientSMS           => "Yes",
                    show_fa_teaser          => "No",
                    statusPostmoderate      => "No",
                    tags_allowed            => "Yes",
                    uid                     => 205058976,
                    use_camp_description    => "Yes",
                    ya_counters             => 0
                }
            ]
        }
    },
    clients_options              => {
        original_db => PPC(shard => 'all'),
        rows        => {
        },
    },
    vcards                       => {
        original_db => PPC(shard => 'all'),
        rows        => {
            $TEST_SHARD => [
                {
                    address_id        => 3534872,
                    apart             => 42,
                    build             => "Е",
                    cid               => 392908217,
                    city              => "Омск",
                    contact_email     => "info\@smazprom.ru",
                    contactperson     => "somebody",
                    country           => "Россия",
                    extra_message     => "Нефтехимическое производство",
                    geo_id            => 66,
                    house             => 38,
                    im_client         => "jabber",
                    im_login          => "ppalex\@yandex-team.ru",
                    LastChange        => "2015-04-10 19:21:33",
                    last_dissociation => "2015-04-10 20:57:35",
                    metro             => undef,
                    name              => "Производственное-научное объединение \"разъединение\"",
                    org_details_id    => 317862,
                    phone             => "+7#3812#64-73-63#99",
                    street            => "Нефтезаводская",
                    uid               => 205058976,
                    vcard_id          => 21451497,
                    worktime          => "0#4#9#00#18#00"
                }
            ]
        }
    },
    banner_turbolandings => {
        original_db => PPC(shard => 'all'),
        rows => {
        },
    },
    banner_permalinks => {
        original_db => PPC(shard => 'all'),
        rows => {
        },
        engine => 'InnoDB',
    },
    organizations => {
        original_db => PPC(shard => 'all'),
        rows => {
        },
    },
};

1;
