#!/usr/bin/perl

# $Id: get_camp_status_info.t 30551 2012-04-10 11:17:24Z eboguslavskaya $

use Direct::Modern;
no warnings 'redefine';

use Test::More;
use Test::Deep;

use POSIX qw/strftime/;
use DateTime::Format::MySQL;
use Yandex::Test::UTF8Builder;

use Yandex::DateTime qw/now/;
use Yandex::TimeCommon;
use Yandex::HashUtils qw/hash_merge/;
use Yandex::DBUnitTest qw/copy_table/;

use Settings;

use Campaign;
use Campaign::Types;
use Models::Banner;
use Client;

use utf8;
$Yandex::DBShards::STRICT_SHARD_DBNAMES = 0;

copy_table(PPCDICT, "geo_timezones");
copy_table(PPCDICT, "great_holidays");

undef &Models::Banner::has_camp_active_banners;
*Models::Banner::has_camp_active_banners = sub { return $_[0] % 2; };
*Models::Banner::mass_has_camps_active_banners = sub { +{map {$_ => Models::Banner::has_camp_active_banners($_)} @{$_[0]}} };
undef &Campaign::camp_has_banners;
*Campaign::camp_has_banners = sub { return $_[0]->{cid} % 2; };
*Campaign::mass_camps_has_banners = sub { +{map {$_->{cid} => Campaign::camp_has_banners($_)} @{$_[0]}} };
undef &Campaign::camp_kind_in;
*Campaign::camp_kind_in = sub {return 1};
undef &Campaign::get_camp_type;
*Campaign::get_camp_type = sub {return 'text'};
undef &Campaign::camp_delayed_arc;
*Campaign::camp_delayed_arc = sub { return undef; };
undef &Campaign::is_campaign_finished;
*Campaign::is_campaign_finished = sub { 
    my (%O) = @_;
    my $fd = ( defined $O{finish_time} ) ? mysql_round_day($O{finish_time}) : undef;
    return $fd && today() gt $fd ? 1 : 0;
};
*Campaign::is_campaign_finished_mass = sub { +{map {$_->{cid} => Campaign::is_campaign_finished(%$_)} @{$_[0]}} };

# кампания № 5 -- у мультивалютного клиента
*Client::get_client_currencies = sub {
     my $currency = ($_[0]->{cid} == 5) ? 'EUR' : 'YND_FIXED';
     return {work_currency => $currency, pay_currency => $currency};
};

*gcsi   = \&Campaign::get_camp_status_info;
*ccs    = \&Campaign::CalcCampStatus;

my $now_dt = now();
my $now = DateTime::Format::MySQL->format_datetime( $now_dt );

my $today_dt = now()->truncate( to => 'day' );
my $today = DateTime::Format::MySQL->format_datetime( $today_dt );

my $yesterday_dt = now()->subtract( days => 1 )->truncate( to => 'day' );
my $yesterday = DateTime::Format::MySQL->format_datetime( $yesterday_dt );

my $tomorrow_dt = now()->add( days => 1 )->truncate( to => 'day' );
my $tomorrow = DateTime::Format::MySQL->format_datetime( $tomorrow_dt );

my $stop_time_dt = now()->subtract( seconds => ( $Settings::TRANSFER_DELAY_AFTER_STOP + 10 ) );
my $stop_time = DateTime::Format::MySQL->format_datetime( $stop_time_dt );

my @tests = ( 
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 9.999900,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
        },
        'Идут показы',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 9.999900,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            activation        => 1,
            moderate          => 'Yes',
        },
        'Идут показы. Идет активизация',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 9.999900,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1AbBbCbDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
        },
        'Идут показы',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 9.999900,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1AbBbCbDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            activation        => 1,
            moderate          => 'Yes',
        },
        'Идут показы. Идет активизация',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
        },
        'Идут показы',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            activation        => 1,
            moderate          => 'Yes',
        },
        'Идут показы. Идет активизация',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1AbBbCbDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
        },
        'Идут показы',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1AbBbCbDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            activation        => 1,
            moderate          => 'Yes',
        },
        'Идут показы. Идет активизация',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 9.999999999,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            money_finished    => 1,
            moderate          => 'Yes',
        },
        'Средства на счете закончились',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 9.999999999,
            start_time => strftime("%Y%m%d", localtime) - 10,
            statusModerate => 'Sent',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            money_finished    => 1,
            moderate          => 'Sent',
        },
        'Ожидает модерации',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 10,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            money_finished    => 1,
            moderate          => 'Yes',
        },
        'Средства на счете закончились',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 10,
            start_time => strftime("%Y%m%d", localtime) - 10,
            statusModerate => 'Sent',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            money_finished    => 1,
            moderate          => 'Sent',
        },
        'Ожидает модерации',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 1,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'No',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            stopped           => 1,
            moderate          => 'Yes',
        },
        'Кампания остановлена',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 1,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'No',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            stopped           => 1,
            activation        => 1,
            moderate          => 'Yes',
        },
        'Кампания остановлена. Идет активизация',
    ],
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
        },
        'Допущено модератором',
    ],
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $yesterday,
            statusModerate => 'New',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'New',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 10,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'New',
            sum_to_pay        => 1,
        },
        'Черновик. Ждёт оплаты',
    ],
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Yes',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 10,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Sent',
            sum_to_pay        => 1,
        },
        'Ожидает модерации. Ждёт оплаты',
    ],
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 10,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            sum_to_pay        => 1,
        },
        'Ждёт оплаты',
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Yes',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => $stop_time,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Sent',
        },
        'Ожидает модерации',
    ],
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $today,
            statusModerate => 'No',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Yes',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => $stop_time,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'No',
        },
        'Отклонено модератором',
    ],
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $today,
            statusModerate => 'No',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Yes',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 10,
            statusBsSynced => 'No',
            stopTime => $stop_time,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'No',
            sum_to_pay        => 1,
        },
        'Отклонено модератором',
    ],
    [
        { 
            cid => 2,
            sum => 10,
            sum_spent => 8,
            start_time => $today,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            timetarget        => 'Идут показы',
            no_active_banners => 1,
        },
        'Нет активных объявлений',
    ],
    [
        { 
            cid => 2,
            sum => 10,
            sum_spent => 8,
            start_time => $today,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            timetarget        => 'Идут показы',
            no_active_banners => 1,
            activation        => 1,
        },
        'Нет активных объявлений. Идет активизация',
    ],
    [
        { 
            cid => 2,
            sum => 10,
            sum_spent => 8,
            start_time => $today,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            timetarget        => 'Идут показы',
            no_active_banners => 1,
            activation        => 1,
        },
        'Нет активных объявлений. Идет активизация',
    ],
    [
        { 
            cid => 2,
            sum => 10,
            sum_spent => 8,
            start_time => $today,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            timetarget        => 'Идут показы',
            no_active_banners => 1,
        },
        'Нет активных объявлений',
    ],
    [
        {
            test_name => 'archived_synced',
            cid => 3,
            sum => 10,
            sum_spent => 8,
            start_time => $today,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'No',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            archived => 'Yes',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            stopped           => 1,
            archived          => 1,
        },
        'Кампания перенесена в архив',
    ],
    [
        { 
            cid => 2,
            sum => 10,
            sum_spent => 8,
            start_time => $today,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            archived => 'Yes',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            timetarget        => 'Идут показы',
            no_active_banners => 1,
            activation        => 1,
            archived          => 1,
        },
        'Кампания перенесена в архив. Идет активизация',
    ],
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $tomorrow,
            statusModerate => 'Yes',
            OrderID => 0,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => undef,
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            archived => 'No',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            wait_start        => undef,
        },        
        'Допущено модератором'
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 0,
            start_time => $tomorrow,
            statusModerate => 'Yes',
            OrderID => 0,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => undef,
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            archived => 'No',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            wait_start        => 1,
            timetarget        => 'Идут показы',
            activation        => 1,
        },        
        sprintf('Начало %s. Идет активизация', $tomorrow_dt->dmy('.')), 
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 0,
            start_time => $tomorrow,
            statusModerate => 'Yes',
            OrderID => 0,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => undef,
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            archived => 'No',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            wait_start        => 1,
            timetarget        => 'Идут показы',
        },
        sprintf('Начало %s', $tomorrow_dt->dmy('.')), 
    ],
    # если кампания ещё не началась, то не пишем о том, когда закончится
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 0,
            start_time => $tomorrow,
            finish_time => $tomorrow,
            statusModerate => 'Yes',
            OrderID => 0,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => undef,
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            archived => 'No',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            wait_start        => 1,
            timetarget        => 'Идут показы',
        },
        sprintf('Начало %s', $tomorrow_dt->dmy('.')), 
    ],
    # последний день, в который кампания работает -- дата окончания
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            finish_time => $today,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            type => 'text',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            timetarget        => 'Идут показы',
        },
        sprintf('Идут показы. Дата окончания кампании %s',$today_dt->dmy('.')),
    ],
    # если на кампании есть деньги и она закончилась, то статус "Кампания закончилась"
    [
        {
            cid => 1,
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            finish_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            type => 'text',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            timetarget        => 'Идут показы',
            finished          => 1,
        },
        sprintf('Кампания закончилась %s', $yesterday_dt->dmy('.')),
    ],
    # для остальных статусов при установленной и непрошедшей дате окончания должна быть приписка о дате окончания
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $yesterday,
            finish_time => $tomorrow,
            statusModerate => 'New',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'New',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'New',
        },
        sprintf('Черновик. Дата окончания кампании %s', $tomorrow_dt->dmy('.')),
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 1,
            start_time => $yesterday,
            finish_time => $tomorrow,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'No',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            stopped           => 1,
            moderate          => 'Yes',
        },
        sprintf('Кампания остановлена. Дата окончания кампании %s', $tomorrow_dt->dmy('.')),
    ],
    
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $yesterday,
            finish_time => $tomorrow,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 10,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            sum_to_pay        => 1,
        },
        sprintf('Ждёт оплаты. Дата окончания кампании %s', $tomorrow_dt->dmy('.')),
    ],
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $yesterday,
            finish_time => $tomorrow,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
        },
        sprintf('Допущено модератором. Дата окончания кампании %s', $tomorrow_dt->dmy('.')),
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 9.999999999,
            start_time => $yesterday,
            finish_time => $tomorrow,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            money_finished    => 1,
        },
        sprintf('Средства на счете закончились. Дата окончания кампании %s', $tomorrow_dt->dmy('.')),
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 10,
            start_time => $yesterday,
            finish_time => $tomorrow,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            money_finished    => 1,
        },
        sprintf('Средства на счете закончились. Дата окончания кампании %s', $tomorrow_dt->dmy('.')),
    ],
    [
        {
            cid => 1,
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            finish_time => $tomorrow,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
        },
        sprintf('Идут показы. Дата окончания кампании %s', $tomorrow_dt->dmy('.')),
    ],
    # бывает и тройной составной статус
    [
        {
            cid => 1,
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            finish_time => $tomorrow,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            activation        => 1,
            moderate          => 'Yes',
        },
        sprintf('Идут показы. Идет активизация. Дата окончания кампании %s', $tomorrow_dt->dmy('.')),
    ],
    # а при прошедшей дате окончания должна быть приписка о том, что кампания закончилась
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $yesterday,
            finish_time => $yesterday,
            statusModerate => 'New',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'New',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'New',
        },
        sprintf('Черновик. Кампания закончилась %s', $yesterday_dt->dmy('.')),
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 1,
            start_time => $yesterday,
            finish_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'No',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            stopped           => 1,
            moderate          => 'Yes',
        },
        sprintf('Кампания остановлена. Кампания закончилась %s', $yesterday_dt->dmy('.')),
    ],
    
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $yesterday,
            finish_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 10,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            sum_to_pay        => 1,
        },
        sprintf('Ждёт оплаты. Кампания закончилась %s', $yesterday_dt->dmy('.')),
    ],
    [
        { 
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $yesterday,
            finish_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
        },
        sprintf('Допущено модератором. Кампания закончилась %s', $yesterday_dt->dmy('.')),
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 9.999999999,
            start_time => $yesterday,
            finish_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            money_finished    => 1,
        },
        sprintf('Средства на счете закончились. Кампания закончилась %s', $yesterday_dt->dmy('.')),
    ],
    [
        { 
            cid => 1,
            sum => 10,
            sum_spent => 10,
            start_time => $yesterday,
            finish_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            money_finished    => 1,
        },
        sprintf('Средства на счете закончились. Кампания закончилась %s', $yesterday_dt->dmy('.')),
    ],
    # для лёгких пользователей не должна добавляться приписка "Ждёт оплаты"
    [
        {
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $today,
            statusModerate => 'No',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'Yes',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHOPQRSTUVWX4ABCDEFGHIJOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 10,
            statusBsSynced => 'No',
            stopTime => $stop_time,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'No',
            sum_to_pay        => 1,
        },
        'Отклонено модератором',
        {
            easy_user => 1,
        },
    ], 
    # если дневной бюджет установлен, но ещё не закончился, в состоянии кампании ничего измениться не должно
    [
        {
            cid => 1,
            sum => 100,
            sum_spent => 80,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 10,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => "0000-00-00 00:00:00",
            spent_today => 0,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
        },
        'Идут показы',
    ],
    # если дневной бюджет установлен и закончился, но нет времени - считаем что идут показы
    [
        {
            cid => 1,
            sum => 100,
            sum_spent => 80,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 10,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => "0000-00-00 00:00:00",
            spent_today => 10,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
        },
        'Идут показы',
    ],
    [
        {
            cid => 1,
            sum => 100,
            sum_spent => 80,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 10,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => $now,
            spent_today => 9,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
            day_budget        => 1,
        },
        sprintf('Показы приостановлены по дневному ограничению в %02d:%02d (MSK)', $now_dt->hour(), $now_dt->minute()),
    ],
    [
        camp(active => 1, patch => {wallet_cid => 2, wallet_day_budget => 1230, wallet_day_budget_stop_time => $now}),
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
            paused_by_wallet_day_budget => 1,
        },
        sprintf('Показы приостановлены по дневному ограничению общего счёта в %02d:%02d (MSK)', $now_dt->hour(), $now_dt->minute()),
    ],
    [
        camp(active => 1, patch => {wallet_cid => 2, wallet_day_budget => 1230, wallet_day_budget_stop_time => $yesterday}),
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
        },
        'Идут показы',
    ],
    #################################################################################################
    # Кампании без объявлений во всех случаях должны иметь статус "Нет объявлений", кроме черновиков
    [ # обычная кампания без объявлений
        {
            cid => 1,
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 0,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
            no_banners        => 1,
            no_active_banners => 1,
        },
        'Нет объявлений',
    ],
    [ # непромодерированная кампания без объявлений
        {
            cid => 1,
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            statusModerate => 'Sent',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Yes',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 0,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Sent',
            no_banners        => 1,
        },
        'Нет объявлений',
    ],
    [ # кампания-черновки без объявлений
        {
         
            cid => 1,
            sum => 0,
            sum_spent => 0,
            start_time => $yesterday,
            statusModerate => 'New',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'No',
            statusPostModerate => 'New',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'No',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 0,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'New',
            no_banners        => 1,
        },
        'Черновик',
    ],
    [ # архивная кампания должна оставаться архивной
        {
            test_name => 'archived_synced',
            cid => 3,
            sum => 10,
            sum_spent => 8,
            start_time => $today,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'No',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            archived => 'Yes',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 0,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            stopped           => 1,
            archived          => 1,
            no_banners        => 1,
        },
        'Кампания перенесена в архив',
    ],
    [ # если не передавать has_banners, то функция должна получать данные из базы (в данном случае баннеры есть)
        {
            cid => 1, # у нечётных кампаний есть баннеры
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
        },
        'Идут показы',
    ],
    [ # если не передавать has_banners, то функция должна получать данные из базы  (в данном случае баннеров нет)
        {
            cid => 2, # у чётных кампаний нет баннеров
            sum => 10,
            sum_spent => 8,
            start_time => $yesterday,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'Yes',
            statusActive => 'Yes',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            timetarget        => 'Идут показы',
            moderate          => 'Yes',
            no_banners        => 1,
            no_active_banners => 1,
        },
        'Нет объявлений',
    ],
    [
        {
            test_name => 'несконвертированная кампания у мультивалютного клиента',
            cid => 5,
            sum => 10,
            sum_spent => 8,
            start_time => $today,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'No',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            archived => 'Yes',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            stopped           => 1,
            archived          => 1,
        },
        'Кампания перенесена в архив',
    ],
    [
        {
            test_name => 'сконвертированная кампания у мультивалютного клиента',
            cid => 5,
            sum => 10,
            sum_spent => 8,
            start_time => $today,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'No',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            archived => 'Yes',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'Yes',
            currency => 'YND_FIXED',
        },
        {
            moderate          => 'Yes',
            stopped           => 1,
            archived          => 1,
            currency_converted=> 1,
        },
        'Сконвертирована',
    ],
    [
        {
            test_name => 'мультивалютная кампания у мультивалютного клиента',
            cid => 5,
            sum => 10,
            sum_spent => 8,
            start_time => $today,
            statusModerate => 'Yes',
            OrderID => 1,
            statusShow => 'No',
            statusActive => 'No',
            statusPostModerate => 'Accepted',
            timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8ABCDEFGHIJKLMNOPQRSTUVWX',
            timezone_id => 131,
            sum_to_pay => 0,
            statusBsSynced => 'Yes',
            stopTime => undef,
            archived => 'Yes',
            day_budget => 0,
            day_budget_daily_change_count => 0,
            day_budget_show_mode => 'default',
            day_budget_stop_time => undef,
            has_banners => 1,
            currencyConverted => 'No',
            currency => 'EUR',
        },
        {
            moderate          => 'Yes',
            stopped           => 1,
            archived          => 1,
        },
        'Кампания перенесена в архив',
    ],
);

my $base_result = {
    wait_start        => undef,
    finished          => undef,
    money_finished    => undef,
    stopped           => undef,
    timetarget        => undef,
    moderate          => undef,
    sum_to_pay        => undef,
    activation        => undef,
    no_active_banners => undef,
    archived          => undef,
    delayed_arc       => undef,
    day_budget        => undef,
    no_banners        => undef,
    currency_converted=> undef,
    paused_by_wallet_day_budget => undef,
    strategy_finished => undef,
    no_deals => undef,
};
for my $t (@tests) {
    my %base = %$base_result;
    cmp_deeply(gcsi($t->[0]), hash_merge(\%base, $t->[1]), $t->[2].' (get_camp_status_info)');
    is(ccs($t->[0], %{ $t->[3] || {} })->{text}, $t->[2], $t->[2].' (CalcCampStatus)');
    if ($t->[2] =~ /Кампания закончилась/) {
        ok(ccs($t->[0], %{ $t->[3] || {} })->{is_over}, 'Флаг "Кампания закончилась"')
    } else {
        ok(!ccs($t->[0], %{ $t->[3] || {} })->{is_over}, 'Флага "Кампания закончилась" нет')
    }
}

sub camp {
    my (%O) = @_;

    # новенькая кампания-черновик
    state $default_camp = {
        cid => 1,
        sum => 0,
        sum_spent => 0,
        start_time => $yesterday,
        statusModerate => 'New',
        OrderID => 1,
        statusShow => 'Yes',
        statusActive => 'No',
        statusPostModerate => 'New',
        timeTarget => '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX8',
        timezone_id => 131,
        sum_to_pay => 0,
        statusBsSynced => 'No',
        stopTime => undef,
        day_budget => 0,
        day_budget_daily_change_count => 0,
        day_budget_show_mode => 'default',
        day_budget_stop_time => undef,
        has_banners => 1,
        currencyConverted => 'No',
        currency => 'RUB',
    };

    my %result = %$default_camp;

    if ($O{active}) {
        $O{moderated} = 1;
    }

    if ($O{moderated}) {
        $result{statusModerate} = 'Yes';
        $result{statusPostModerate} = 'Accepted';
    }

    if ($O{active}) {
        $result{statusActive} = 'Yes';
        $result{statusBsSynced} = 'Yes';
        $result{sum} = 1234.5;
    }

    if ($O{patch}) {
        hash_merge(\%result, $O{patch});
    }

    return \%result;
}

done_testing();
