#!/usr/bin/perl

use warnings;
use strict;
use utf8;
use open ':std' => ':utf8';

use Test::More;
use GeoTools;

my @tests = (
[[0], "Россия, СНГ (исключая Россию), Европа, Азия, Африка, Северная Америка, Южная Америка, Австралия и Океания"],
[[1], "Москва и область"],
[[2], "Санкт-Петербург"],
[[], "Россия, СНГ (исключая Россию), Европа, Азия, Африка, Северная Америка, Южная Америка, Австралия и Океания"],
[[''], "Россия, СНГ (исключая Россию), Европа, Азия, Африка, Северная Америка, Южная Америка, Австралия и Океания"],
[['1,-10723,-214,-215,-10739,11235,21949'], "Москва и область (кроме: Дмитров, Долгопрудный, Дубна, Можайск), Алтайский край, Забайкальский край"],
[[116], "Венгрия"],
[['3,17,10995,-1107,-970,-1058,11029,-238,-971,11070,11079,-972,11131,-240,11146'],
    "Центр, Северо-Запад, Краснодарский край (кроме: Анапа, Новороссийск, Туапсе), Ростовская область (кроме: Новочеркасск, Таганрог), Кировская область, Нижегородская область (кроме: Дзержинск (Нижегородская область)), Самарская область (кроме: Тольятти), Саратовская область"],
[['3,17', "; "], "Центр; Северо-Запад"],
[['1,10174,-969,-10867', '/'], "Москва и область/Санкт-Петербург и Ленинградская область (кроме: Выборг/Гатчина)"]);

is(get_geo_names(@{$_->[0]}), $_->[1]) foreach @tests;

done_testing();
