#!/usr/bin/perl

use strict;
use warnings;

use Yandex::Test::UTF8Builder;
use Test::More;

use GeoTools;

use utf8;

*gtu = sub {
    my ($geo_list, $opts) = (@_);
    return get_targetings_union($geo_list, $opts);
};


my $opts = {tree => 'ru'};

is(gtu(['225,-3,1','225,-1'], $opts), '225', 'Россия -Центр Москва && Россия -Москва => Россия');
is(gtu(['225,-1,-10174','225,-3'], $opts), '225,-1', 'Россия -Москва -Питер && Россия -Центр => Россия -Москва');
is(gtu(['225,-1,-10174','3'], $opts), '225,-10174', 'Россия -Москва -Питер && Центр => Россия -Питер');
is(gtu(['225,-1','187,-20544'], $opts), '187,-20544,225,-1', 'Россия -Москва && Украина -Киев => Украина -Киев Россия -Москва');
is(gtu(['225,-1','187,-20544','3'], $opts), '187,-20544,225', 'Россия -Москва && Украина -Киев && Центр => Украина -Киев Россия');
is(gtu(['225,-1','187,-20544','3'], $opts), '187,-20544,225', 'Россия -Москва && Украина -Киев && Центр => Украина -Киев Россия');
is(gtu(['44','11148,-11150,-11152','11095'], $opts), '11095,11148,-11150,-11152', 
				'Ижевск && Удмуртская Республика -Глазов -Сарапул && Пензенская область => Пензенская область Удмуртская Республика -Глазов -Сарапул');

done_testing();
