#!/usr/bin/perl

use strict;
use warnings;
use Test::More;

use GeoTools;

use utf8;
use open ':std' => ':utf8';

sub mtr1 {
    my ($region, $opt) = @_;
    return GeoTools::modify_translocal_region_before_save($region, $opt);
};

is(mtr1("225", {tree => 'ua'}), "225");
is(mtr1("225", {tree => 'ru'}), "225,977");
is(mtr1("225,977", {tree => 'ru'}), "225,977");
is(mtr1("225,118", {tree => 'ua'}), "225,118");
is(mtr1("225,118", {tree => 'ru'}), "225,118,977");

is(mtr1("187", {tree => 'ua'}), "187,977");
is(mtr1("187,977", {tree => 'ua'}), "187,977");
is(mtr1("187", {tree => 'ru'}), "187");
is(mtr1("187,118", {tree => 'ua'}), "187,118,977");
is(mtr1("187,118,977", {tree => 'ua'}), "187,118,977");
is(mtr1("187,118", {tree => 'ru'}), "187,118");

is(mtr1("149", {tree => 'ua'}), "149");
is(mtr1("149", {tree => 'ru'}), "149");

# если есть регион включающий Украину/Россию
# СНГ (без России)
is(mtr1("166", {tree => 'ru'}), "166");
is(mtr1("166", {tree => 'ua'}), "166,977");
is(mtr1("166,977", {tree => 'ua'}), "166,977");
is(mtr1("166,118", {tree => 'ru'}), "166,118");
is(mtr1("166,118", {tree => 'ua'}), "166,118,977");
is(mtr1("166,118,977", {tree => 'ua'}), "166,118,977");
is(mtr1("166, 118, 977", {tree => 'ua'}), "166,118,977"); # с пробелами

# Весь мир - не модифицируем
is(mtr1("0", {tree => 'ru'}), "0");
is(mtr1("0", {tree => 'ua'}), "0");

# вычитание Крыма не записываем
is(mtr1("187,-977", {tree => 'ru'}), "187");
is(mtr1("225,-977", {tree => 'ua'}), "225");
is(mtr1("187,-977", {tree => 'ua'}), "187");
is(mtr1("225,-977", {tree => 'ru'}), "225");

# такой вариант может быть только в АПИ
is(mtr1("0,-977", {tree => 'ua'}), "0,-977");
is(mtr1("0,-977", {tree => 'ru'}), "0,-977");
is(mtr1("0,187,-977", {tree => 'ua'}), "0,187,-977");
is(mtr1("0,225,-977", {tree => 'ru'}), "0,225,-977");
is(mtr1("0, 225, -977", {tree => 'ru'}), "0,225,-977"); # с пробелами

is(mtr1("225,-187", {tree => 'ua'}), "225,-187");
is(
    # из "СНГ" вычли все подрегионы
    mtr1(
        "225,-26,-73,-102444,59,-11235,-21949,-11266,-11282,-11316,-10231,-11353,166,-29386,-167,-168,-149,-159,-207,-208,-209,-170,-171,-187",
        {tree => 'ua'}
    ),
    "225,-26,-73,-102444,59,-11235,-21949,-11266,-11282,-11316,-10231,-11353,166,-29386,-167,-168,-149,-159,-207,-208,-209,-170,-171,-187"
);
is(mtr1("20525,20528,-20552,-20551", {tree => "ua"}), "20525,20528,-20552,-20551");
is(
    # из "СНГ" вычли все подрегионы
    mtr1(
        "225,-26,-73,-102444,59,-11235,-21949,-11266,-11282,-11316,-10231,-11353,166,-29386,-167,-168,-149,-159,-207,-208,-209,-170,-171,-187",
        {tree => 'ru'}
    ),
    "225,-26,-73,-102444,59,-11235,-21949,-11266,-11282,-11316,-10231,-11353,166,-29386,-167,-168,-149,-159,-207,-208,-209,-170,-171,-187,977"
);

# undef не меняем
is(mtr1(undef, {tree => 'ua'}), undef);
is(mtr1(undef, {tree => 'ru'}), undef);
is(mtr1(undef, {tree => 'api'}), undef);

#---------------------------------------------

sub mtr2 {
    my ($region, $opt) = @_;
    return GeoTools::modify_translocal_region_before_show($region, $opt);
};

is(mtr2("187", {tree => 'ru'}), "187");
is(mtr2("187", {tree => 'ua'}), "187,-977");

is(mtr2("225", {tree => 'ua'}), "225");
is(mtr2("225", {tree => 'ru'}), "225,-977");

is(mtr2("187,977", {tree => 'ru'}), "187,977");
is(mtr2("187, 977", {tree => 'ru'}), "187,977");
is(mtr2("187,977", {tree => 'ua'}), "187");
is(mtr2("166,977", {tree => 'ua'}), "166"); # СНГ

is(mtr2("225,977", {tree => 'ua'}), "225,977");
is(mtr2("225,977", {tree => 'ru'}), "225");

is(mtr2("187,-977", {tree => 'ru'}), "187");
is(mtr2("187,-977", {tree => 'ua'}), "187,-977");

is(mtr2("225,-977", {tree => 'ua'}), "225");
is(mtr2("225,-977", {tree => 'ru'}), "225,-977");

# Весь мир - не модифицируем
is(mtr2("0", {tree => 'ru'}), "0");
is(mtr2("0", {tree => 'ua'}), "0");

# если есть Крым и минус регион из Крыма, то сам Крым не нужно удалять
is(mtr2("187,977,-146", {tree => 'ua'}), "187,977,-146");
is(mtr2("225,977,-146", {tree => 'ru'}), "225,977,-146");
is(mtr2("225, 977, -146", {tree => 'ru'}), "225,977,-146"); # с пробелами

# другие минус регионы не должны влиять
is(mtr2("187,977,-20536", {tree => 'ua'}), "187,-20536");
is(mtr2("225,977,-3", {tree => 'ru'}), "225,-3");

# с пробелами
is(mtr2("187, 977, -20536", {tree => 'ua'}), "187,-20536");
is(mtr2("225 ,  977, -3", {tree => 'ru'}), "225,-3");

# undef не меняем
is(mtr2(undef, {tree => 'ua'}), undef);
is(mtr2(undef, {tree => 'ru'}), undef);
is(mtr2(undef, {tree => 'api'}), undef);


done_testing();
