#!/usr/bin/perl

# $Id$

use warnings;
use strict;
use Test::More tests => 12;

BEGIN { use_ok( 'IpTools' ); }

*in = \&IpTools::is_ip_in_networks;

ok(in('213.180.218.72', ' 213.180.218.72 , '), "eq");
ok(in('213.180.218.72', ' 123.234.34.12, 213.180.218.72 , '), "eq list");
ok(!in('213.180.218.71', ' 123.234.34.12, 213.180.218.72 , '), "ne list");

ok(!in('213.180.218.73', ' 123.234.34.12, 213.180.218.72/32 , '), "ne nw list");
ok(!in('213.180.218.75', ' 123.234.34.12, 213.180.218.72/31 , '), "ne nw list");
ok(in('213.180.218.75', ' 123.234.34.12, 213.180.218.72/30 , '), "in nw list");
ok(!in('213.180.218.76', ' 123.234.34.12, 213.180.218.72/30 , '), "nw right bound");

ok(in('213.180.218.76', '213.180.218.73 - 213.180.218.76'), "diap");
ok(in('213.180.218.71', '213.180.212.1 - 213.180.220.1'), "wide diap in");
ok(!in('213.180.218.76', '213.180.218.73 - 213.180.218.75'), "diap left");
ok(!in('213.180.218.72', '213.180.218.73 - 213.180.218.75'), "diap right");

