#!/usr/bin/perl

use Direct::Modern;

use Test::More;

use MobileContent;


local $MobileContent::USED_VERSION_PARTS = 2;
*c = \&MobileContent::_cmp_os_versions;

my @tests = (
    # [$v1, $v2, $cmp_res]
    [undef, undef, 0],
    [0, undef, 0],
    [0.0, undef, 0],
    ['0', undef, 0],
    ['0.0', undef, 0],
    ['0.0.0', undef, 0],
    ['0.0.1', undef, 0],
    ['0', '0', 0],
    ['0', '1', -1],
    ['1', '0', 1],
    ['0.0', '0.0', 0],
    ['0.0', '0.1', -1],
    ['0.1', '0.0', 1],
    ['0.0', '1.0', -1],
    ['1.0', '0.0', 1],
    ['1.0', '1.0', 0],
    ['1.0', '1.1', -1],
    ['1.1', '1.0', 1],
    ['1.1', '1.1', 0],
    ['1.20', '1.1', 1],
    ['1.20', '1.2', 1],
    ['1.20', '1.5', 1],
    ['1.20', '1.15', 1],
    ['1.09', '1.15', -1],
    ['1.9', '1.15', -1],
    ['1.9', '1.09', 0],
    ['1.90', '1.15', 1],
    ['1.1.0', '1.1.0', 0],
    ['1.1.0', '1.1.1', 0],
    ['1.1.1', '1.1.0', 0],
    ['0.10', '0.1', 1],
    ['0.10', '0.10', 0],
    ['0.10', '0.010', 0],
    ['0.09', '0.10', -1],
);

Test::More::plan(tests => scalar(@tests));

note(sprintf('     %20s <=> %-20s ->  %s', 'version1', 'version2', 'result'));
for my $t (@tests) {
    is(c($t->[0], $t->[1]), $t->[2], sprintf('%20s <=> %-20s -> %2d', ($t->[0] // 'undef'), ($t->[1] // 'undef'), $t->[2]));
}

done_testing();
