#!/usr/bin/perl

use warnings;
use strict;
use TextTools;
use utf8;

use Test::More;

#                0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001
#                0000000001111111111222222222233333333334444444444555555555566666666667777777777888888888899999999990
#                1234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890
my $long_str =  'ехал грека через реку, видит грека в реке грека, сунул грека греку в греку. Грека грека грека грека.';

my @test_cases = (
    [
        '',
        33,
        '',
        ''
    ], [
        'ехал грека через реку',
        33,
        'ехал грека через реку',
        ''
    ], [
        $long_str,
        49,
        'ехал грека через реку, видит грека в реке грека',
        ', сунул грека греку в греку. Грека грека грека грека.'
    ], [
        $long_str,
        48,
        'ехал грека через реку, видит грека в реке грека',
        ', сунул грека греку в греку. Грека грека грека грека.'
    ], [
        $long_str,
        47,
        'ехал грека через реку, видит грека в реке грека',
        ', сунул грека греку в греку. Грека грека грека грека.'
    ], [
        $long_str,
        46,
        'ехал грека через реку, видит грека в реке',
        'грека, сунул грека греку в греку. Грека грека грека грека.'
    ], [
        $long_str,
        4,
        'ехал',
        'грека через реку, видит грека в реке грека, сунул грека греку в греку. Грека грека грека грека.'
    ], [
        $long_str,
        3,
        '',
        'ехал грека через реку, видит грека в реке грека, сунул грека греку в греку. Грека грека грека грека.'
    ], 
);

Test::More::plan(tests => scalar(@test_cases) * 2);

for my $arr (@test_cases){
    my ($text, $limit, $expected_first_words, $expected_rest) = @$arr;

    my ($first_words, $rest) = TextTools::extract_first_words($text, $limit);
    is($first_words, $expected_first_words);
    is($rest, $expected_rest);
}
