#!/usr/bin/perl

use warnings;
use strict;
use utf8;

use Test::More;

use TimeTarget;

my @tests = (
    '' => 0,
    undef, 0,
    '1ABHIJKLMNOPQRSTUVWX2ABHIJKLMNOPQRSTUVWX3ABHIJKLMNOPQRSTUVWX4ABHIJKLMNOPQRSTUVWX5ABHIJKLMNOPQRSTUVWX6ABHIJKLMNOPQRSTUVWX7ABHIJKLMNOPQRSTUVWX9;p:o'
    => 0,
    '1ABCDEFGHIJKLMNOPQRSTUVWX2ABCDEFGHIJKLMNOPQRSTUVWX3ABCDEFGHIJKLMNOPQRSTUVWX4ABCDEFGHIJKLMNOPQRSTUVWX5ABCDEFGHIJKLMNOPQRSTUVWX6ABCDEFGHIJKLMNOPQRSTUVWX7ABCDEFGHIJKLMNOPQRSTUVWX9'
    => 0,
    '1GHIJKLMNOPQRSTUVWX2GHIJKLMNOPQRSTUVWX3GHIJKLMNOPQRSTUVWX4GHIJKLMNOPQRSTUVWX5GHIJKLMNOPQRSTUVWX6IJKLMNOPQRSTUVWX'
    => 0,
    '-----67ABCDEFGHI-----------UVWX'
    => 0,
    '1JKLMNOPQRSTUVbWb2JKLMNOPQRSTUWb3JKLMNOPQRSTUWb4JKLMNOPQRSTUWb5JKLMNOPQRSTUWb6JKLMNOPQRSTUWb7JKLMNOPQRSTUWb9;p:o'
    => 1,
    '1ABeCbDbEbFeGHIJKLMNOPQRSTUVWX2ABeCbDbEbFeGHIJKLMNOPQRSTUVWX3ABeCbDbEbFeGHIJKLMNOPQRSTUVWX4ABeCbDbEbFeGHIJKLMNOPQRSTUVWX5ABeCbDbEbFeGHIJKLMNOPQRSTUVWX6ABeCbDbEbFeGHIJKLMNOPQRSTUVWX7ABeCbDbEbFeGHIJKLMNOPQRSTUVWX9;p:w'
    => 1,
    );

while(my ($tt, $res) = splice @tests, 0, 2) {
    is(!!TimeTarget::is_extended_timetarget($tt), !!$res);
}

done_testing();
