#!/usr/bin/perl

=pod
    $Id$
=cut

use strict;
use warnings;

use Yandex::Test::UTF8Builder;
use Test::More;
use Test::Deep;

BEGIN { use_ok('VCards', 'get_worktime'); }

use utf8;

*gwt = sub { get_worktime(@_); };

my $period_re =  {
    'd1' => re('^..$'),
    'd2' => re('^(..)?$'),  # изменил с .. на (..)?, потому что для интервала день-в-день результат ''
    'h1' => re('^\d+$'),
    'm1' => re('^\d+$'),
    'h2' => re('^\d+$'),
    'm2' => re('^\d+$'),
  };

my $hour24_re = {
    'd1' => re('^..$'),
    'd2' => re('^..$'),
    'h1' => re('^.*\D+.*$'),
    'm1' => '',
    'h2' => '',
    'm2' => '',
  };

cmp_deeply( gwt("0#6#10#00#18#00"), [ $period_re ] , "one period, result as array");
cmp_deeply( gwt("0#4#10#00#18#00;5#6#11#00#17#00"), [ $period_re, $period_re ] , "two periods, result as array");

cmp_deeply( gwt("0#6#9#00#18#15;", "string"), re('\S+') , "one period, result as string");
cmp_deeply( gwt("0#4#10#00#18#00;5#6#11#00#17#00", "string"), re('\S+') , "two periods, result as string");

cmp_deeply( gwt("0#6#00#00#00#00", undef, '24hour'), [ $hour24_re ] , "one period, 24 hour type 1 with leading zero, array");
cmp_deeply( gwt("0#6#0#00#0#0",    undef, '24hour'), [ $hour24_re ] , "one period, 24 hour type 1 w/o leading zero, array");
cmp_deeply( gwt("0#4#00#00#00#00;5#6#11#00#17#00", undef, '24hour'), [ $hour24_re, $period_re ] , "two periods, 24 hour on first place, array");


cmp_deeply( gwt("0#4#00#00#00#00;5#6#11#00#17#00", 'string', '24hour'), re('\S+') , "two periods, 24 hour on first place, string");
is( gwt('', 'string'), '', 'сериализация пустой строки в пустую строку' );
#print STDERR Dump(gwt("0#4#00#00#00#00;5#6#11#00#17#00", 'string', '24hour'));

# Тесты на "склейку" соседних дат с одинаковым временным интервалом
my $sample1 = [
    {
        d1 => 'вт',
        d2 => 'ср',
        h1 => '03',
        h2 => '21',
        m1 => '00',
        m2 => '00',
    },
    {
        d1 => 'сб',
        d2 => 'вс',
        h1 => '11',
        h2 => '17',
        m1 => '00',
        m2 => '00',
    },
];
my $sample2 = [
    {
        d1 => 'пн',
        d2 => 'вт',
        h1 => '12',
        h2 => '18',
        m1 => '15',
        m2 => '45',
    },
    {
        d1 => 'ср',
        d2 => 'сб',
        h1 => '07',
        h2 => '08',
        m1 => '00',
        m2 => '00',
    },
];

cmp_deeply( gwt('1#1#03#00#21#00;2#2#03#00#21#00;5#6#11#00#17#00'), $sample1, 'склейка интервалов 3->2, с ведущим нулем');
cmp_deeply( gwt('1#1#3#00#21#00;2#2#03#00#21#00;5#6#11#00#17#00'), $sample1, 'склейка интервалов 3->2');
cmp_deeply( gwt('0#1#12#15#18#45;2#3#7#00#8#00;4#5#7#00#8#00'), $sample2, 'склейка интервалов 3->2');
cmp_deeply( gwt('4#5#7#00#8#00;0#1#12#15#18#45;2#3#7#00#8#00'), $sample2, 'склейка интервалов 3->2, неверный порядок');
cmp_deeply( gwt('1#1#0#0#00#00;2#2#0#0#00#00'), [ $period_re ], 'склейка интервалов 2->1, круглосуточно, цифрами');

cmp_deeply( gwt('1#1#3#00#21#00;2#2#03#00#21#00;6#6#11#00#17#00;5#5#11#00#17#00'), $sample1, 'склейка интервалов 4->2, неверный порядок');
cmp_deeply( gwt('5#5#7#00#8#00;1#1#12#15#18#45;0#0#12#15#18#45;4#4#7#00#8#00;3#3#7#00#8#00;2#2#7#00#8#00'), $sample2, 'склейка интервалов 6->2, неверный порядок');

cmp_deeply( gwt('1#1#03#00#21#00;2#2#03#00#21#01;5#5#11#00#17#00'), [ $period_re, $period_re, $period_re ], 'не должно склеивать');
cmp_deeply( gwt('3#3#03#1#21#00;2#2#03#00#21#00;5#5#11#00#17#00'), [ $period_re, $period_re, $period_re ], 'не должно склеивать');
cmp_deeply( gwt('0#1#10#00#15#00;2#3#15#00#19#00'), [ $period_re, $period_re ], 'не должно склеивать');
cmp_deeply( gwt('0#1#10#00#10#00;2#3#15#00#15#00'), [ $period_re, $period_re ], 'не должно склеивать');
cmp_deeply( gwt('0#0#18#00#18#00;1#1#00#00#24#00'), [ $period_re, $period_re ], 'не должно склеивать');

# Проверки на склейку или нет при вызове функции с параметром "отслеживать круглосуточную работу"
cmp_deeply( gwt('1#1#0#0#00#00;2#2#0#0#00#00', undef, '24hour'), [ $hour24_re ], 'склейка интервалов 2->1, круглосуточно, словом');
cmp_deeply( gwt('0#1#10#00#10#00;2#3#15#00#15#00', undef, '24hour'), [ $period_re, $period_re ], 'не должно склеивать');

SKIP: { # Пока не реализуем склейку 00:00-00:00 и 00:00-24:00, потому что у нас не заносится в базу 24 часа, вместо них подставляется 00 с помощью js
    skip 'not yet implemented', 2 if 1;

    cmp_deeply( gwt('0#1#0#0#00#00;2#3#0#0#24#00'), [ $period_re ], 'склейка 2->1, разное круглосуточно, цифрами');
    cmp_deeply( gwt('0#1#0#0#00#00;2#3#0#0#24#00', undef, '24hour'), [ $hour24_re ], 'склейка 2->1, разное круглосуточно, словом');
}

# заведомо невалидный вариант - в базе таких быть не должно, потому что проверка при создании визитки отсекает варианты с использованием в двух интервалах одного и того же дня. Но всё равно проверим.
cmp_deeply( gwt('0#1#10#00#15#00;1#2#15#00#19#00'), [ $period_re, $period_re ], 'не должно склеивать');

SKIP: { # Тест-кейсы с ведущим нулем перед номером дня не требуются, т.к. мы получаем данные со страниц без него
        # Их собирает js из параметров value форм. Пока туда никто не стал вписывать с ведущими нулями - все ок.
        # А выбрасывать жалко. Вдруг пригодятся?
    skip 'not required', 6 if 1;

    cmp_deeply( gwt("0#06#10#00#18#00"), [ $period_re ] , "one period, result as array, with trailing zero");
    cmp_deeply( gwt("00#6#10#00#18#00"), [ $period_re ] , "one period, result as array, with trailing zero");

    cmp_deeply( gwt('4#5#7#00#8#00;0#1#12#15#18#45;02#3#7#00#8#00'), $sample2 , 'склейка интервалов 3->2, неверный порядок, с ведущими нулями');
    cmp_deeply( gwt('4#5#7#00#8#00;0#1#12#15#18#45;02#03#07#00#08#00'), $sample2 , 'склейка интервалов 3->2, неверный порядок, с ведущими нулями');
    cmp_deeply( gwt('02#02#03#00#21#00;05#05#11#00#17#00;1#1#03#00#21#00'), $sample1 , 'склейка интервалов 3->2, неверный порядок');
    cmp_deeply( gwt('02#02#03#00#21#00;05#05#11#00#17#00;1#1#03#00#21#00'), $sample1 , 'склейка интервалов 3->2, с ведущими нулями');
}

# DIRECT-21373 Перестаем показывать 00:00-23:45 как "круглосуточно"
cmp_deeply( gwt("0#6#00#00#23#45", undef, '24hour'), [ $period_re ] , "one period, NOT 24 hour type 2, array");
cmp_deeply( gwt("0#4#10#00#20#00;5#6#00#00#23#45", undef, '24hour'), [ $period_re, $period_re ] , "two periods, NOT 24 hour on second place, array");
cmp_deeply( gwt('0#1#0#0#00#00;2#3#0#0#23#45', undef, '24hour'), [ $hour24_re, $period_re ], 'не должно склеивать, круглосуточно и нет, словом');

# Если на все дни недели выбран интервал вида 07:00-07:00, то их необходимо:
#  - склеивать
#  - отображать как круглосуточно
# https://jira.yandex-team.ru/browse/DIRECT-21372?focusedCommentId=3550502&page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel#comment-3550502
cmp_deeply( gwt("0#6#07#00#7#00", undef, '24hour'), [ $hour24_re ], 'вся неделя, время 07-07 -> круглосуточно' );
cmp_deeply( gwt("0#5#07#00#7#00", undef, '24hour'), [ $period_re ], 'НЕ вся неделя, время 07-07 -> НЕ круглосуточно' );
cmp_deeply( gwt("5#6#07#00#7#00;2#2#7#00#07#00;3#4#07#00#07#00;0#1#7#00#7#00", undef, '24hour'), [ $hour24_re ], 'склейка 4->1 (вся неделя), суточный интервал 07-07, круглосуточно' );
cmp_deeply( gwt("5#6#07#00#07#00;2#2#22#00#22#00;3#4#7#00#7#00;0#1#22#00#22#00", undef, '24hour'), [ $period_re, $period_re ], 'склейка 4->2, суточный интервал 07-07, 22-22, НЕ круглосуточно' ); # хотя здесь интервал бессмысленный, пересекается (мысленно) по времени в четверг с 07 до 22 часов. Проверяет то, что их не заменит на "круглосуточно"

done_testing();
