#!/usr/bin/perl

use strict;
use warnings;

use Test::More;
use VCards; 

use utf8;
use Yandex::Test::UTF8Builder;
use Yandex::I18n;

=head2 %test_data

    Данные для теста. Имеют формат:
        [<строка worktime из БД> => <результат, отправляемый в БК в $banner->{ContactInfo}->{WorkTime}>]

   В автоматическом режиме юнит-тесты запускаются без собранных переводов. Поэтому в тестах на отличном
   от русского языках можно использовать только жёстко зафиксированные переводы слова "круглосуточно".

=cut

my @test_data = (
    ['0#3#12#15#20#30;4#5#3#45#20#45' => 'пн-чт 12:15-20:30, пт-сб 3:45-20:45'],
    ['3#3#12#15#20#30' => 'чт 12:15-20:30'],
    ['' => ''],
    ['0#6#0#00#00#00' => 'круглосуточно'],
    ['0#6#9#15#9#15' => 'круглосуточно'],
    ['0#2#0#00#00#00;4#6#0#00#10#00' => 'пн-ср круглосуточно, пт-вс 0:00-10:00'],
    ['0#2#0#00#00#00;4#6#0#15#00#00' => 'пн-ср круглосуточно, пт-вс 0:15-24:00'],
    ['0#2#6#00#6#00;3#6#6#00#6#00' => 'круглосуточно'],
    ['0#2#20#30#00#00' => 'пн-ср 20:30-24:00'],
    ['0#2#20#30#00#15' => 'пн-ср 20:30-0:15'],
    ['0#2#0#15#0#00' => 'пн-ср 0:15-24:00'],
    ['0#2#0#15#0#15' => 'пн-ср 0:15-0:15'],
    ['0#2#0#15#0#0' => 'пн-ср 0:15-24:00'],
    ['0#0#10#15#18#00;1#1#8#00#20#30;2#5#0#00#00#00;6#6#2#00#00#00' => 'пн 10:15-18:00, вт 8:00-20:30, ср-сб круглосуточно, вс 2:00-24:00'],
    ['0#6#8#00#22#00' => 'пн-вс 8:00-22:00'],
    ['0#2#6#00#6#00;3#6#6#00#6#00' => 'Round the clock', 'en'],
    ['0#2#6#00#6#00;3#6#6#00#6#00' => 'Цілодобово', 'uk'],
    # для неописанных языков (казахский) используется русский
    ['0#2#6#00#6#00;3#6#6#00#6#00' => 'круглосуточно', 'kz'],
    # для особых случаев, когда в базе обрезаны нули
    ['0#2#6#0#6#0;3#6#6#0#6#0' => 'Round the clock', 'en'],
    ['0#2#6#0#6#0;3#6#6#0#6#0' => 'Round the clock', 'de'],
    ['0#2#6#0#6#0;3#6#6#0#6#0' => '24 soat', 'uz'],
);

Test::More::plan(tests => scalar(@test_data));

for my $test_case (@test_data) {
    my($worktime_from_db, $worktime_for_bs_should_be, $lang) = @$test_case;
    $lang ||= 'ru';
    my $i18n_lang = ($lang eq 'uk') ? 'ua' : $lang;
    my $lang_guard = Yandex::I18n::init_i18n_guard($i18n_lang);
    is(VCards::get_worktime_for_bs($worktime_from_db, $lang), $worktime_for_bs_should_be, qq/testing get_worktime_for_bs("$worktime_from_db")/);

}

