package ru.yandex.autotests.direct;

import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;

/**
 * Загрузка свойств проекта из файла resource/project.properties
 */
@Resource.Classpath("project.properties")
public class Properties {
    private static Properties properties = null;

    public static Properties getInstance() {
        if (properties == null) {
            properties = new Properties();
        }
        return properties;
    }

    public Properties() {
        PropertyLoader.populate(this);
    }

    /**
     * Адресс продакшена
     */
    @Property("advq.prod")
    private String prodURL = "http://ust1-1.advq.yandex.ru/advq/";

    /**
     * Адресс беты
     */
    @Property("advq.beta")
    private String betaURL = "http://testraw1.advq.yandex.ru/advq/";

    /**
     * Название базы
     */
    @Property("advq.dbname")
    private String dbName = "rus";

    /**
     * Таймаут для подключения к базе.
     */
    @Property("connect.timeout")
    private int connectTimeout = 60;

    /**
     * Количество слов для параметризации каждого теста
     */
    @Property("test.words.count")
    private int testWordsCount = 1;

    public String getProdURL() {
        return prodURL;
    }

    public void setProdURL(String prodURL) {
        this.prodURL = prodURL;
    }

    public String getBetaURL() {
        return betaURL;
    }

    public void setBetaURL(String betaURL) {
        this.betaURL = betaURL;
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getTestWordsCount() {
        return testWordsCount;
    }

    public void setTestWordsCount(int testWordsCount) {
        this.testWordsCount = testWordsCount;
    }

    public String getDbName() {
        return dbName;
    }

}